<?php
// Verificar si se ha enviado el formulario con el correo electrónico
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['correo'])) {
    // Obtener el correo electrónico ingresado
    $correo = $_POST['correo'];

    // Configurar la conexión a la base de datos
    $host = 'localhost';
    $dbUsername = 'anet_re';
    $dbPassword = 'reserva2020';
    $dbName = 'anet_re';

    // Establecer conexión
    $conn = new mysqli($host, $dbUsername, $dbPassword, $dbName);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Consultar si el correo electrónico existe en la base de datos
    $query = "SELECT correo FROM registros WHERE correo = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $correo);
    $stmt->execute();
    $stmt->store_result();

    // Si el correo existe, redireccionar a live.php
    if ($stmt->num_rows > 0) {
        header("Location: live.php");
        exit();
    } else {
        // Si el correo no existe, mostrar un mensaje de error
        $error = "Usuario no registrado";
    }

    // Cerrar la conexión
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ingreso al Evento</title>
    <style>
        body {
            background-color: #F9F9F9;
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            width: 80%;
            max-width: 600px;
            text-align: center;
        }
        input[type="email"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }
        input[type="submit"] {
            background-color: #4CAF50; /* Green */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 16px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 5px;
        }
        .error {
            color: red;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Ingreso al Evento</h1>
        <form action="ingreso_evento.php" method="POST">
            <input type="email" name="correo" placeholder="Ingrese su correo electrónico" required>
            <br>
            <input type="submit" value="Ingresar">
        </form>
        <?php if (isset($error)): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>
    </div>
</body>
</html>
