<?php 
$current_timestamp = current_time( 'timestamp', false ); 
$formatted_date = date('Y-m-d\TH:i', $current_timestamp);
$formatted_time = date('H:i', $current_timestamp);

$min_year = $part['min_year'];
$max_year = $part['max_year'];

$max_hour_val = $part['max_hour'];
if( $part['time_format']==12) {
	$max_hour_val += 11;
}
$min_hour = str_pad($part['min_hour'], 2, '0', STR_PAD_LEFT) . ":00";
$max_hour = str_pad($max_hour_val, 2, '0', STR_PAD_LEFT) . ":59";


$current_value = ( happyforms_get_part_value( $part, $form, 'datetime' ) ) ? happyforms_get_part_value( $part, $form, 'datetime' ) : '';

if ($current_value == "") {
	if ('current' === $part['default_datetime']) {
		$current_value = $formatted_date;
	}
}
?>

<div class="happyforms-part-date__date-input happyforms-part--date__input-wrap happyforms-part-date-input--date">
	<div class="happyforms-custom-date" data-searchable="true">
		<div class="happyforms-part__date-wrap">
			<div class="happyforms-input">
				<input type="datetime-local" min="<?php echo $min_year;?>-01-01T<?php echo $min_hour;?>" max="<?php echo $max_year;?>-12-31T<?php echo $max_hour;?>" value="<?php echo $current_value;?>" name="<?php happyforms_the_part_name( $part, $form ); ?>[datetime]" data-serialize required class="happyforms-date-field" />
			</div>
		</div>
	</div>
</div>
