<div class="<?php happyforms_the_part_class( $part, $form ); ?>" id="<?php happyforms_the_part_id( $part, $form ); ?>-part" <?php happyforms_the_part_data_attributes( $part, $form ); ?>>
	<div class="happyforms-part happyforms-form__part">
		<div class="happyforms-part-wrap">
			<?php happyforms_the_part_label( $part, $form ); ?>

			<?php happyforms_print_part_description( $part ); ?>

			<?php do_action( 'happyforms_part_input_before', $part, $form ); ?>

			<?php
			$currency = $part['currency'];
			$currencies = happyforms_payment_get_currencies();
			$currency_symbol = $currencies[$currency]['symbol'];
			$price_class = 'price';
			$coupon = happyforms_get_part_value( $part, $form, 'coupon' );
			$discounted_price = '';

			?>

			<div class="happyforms-part__el">
				<?php if ( happyforms_is_falsy( $part['show_user_price_field'] ) ) : ?>
					<?php
					if ( happyforms_is_truthy ( $part['accept_coupons'] ) && '' != $coupon ) {
						$price = $part['price'];
						$price_class .= ' strikethrough';
						$discounted_price = $currency_symbol . happyforms_get_part_value( $part, $form, 'price' );
					} else {
						$price = happyforms_get_part_value( $part, $form, 'price' );
						$price = ( ! empty( $price ) ) ? $price : $part['price'];
					}
					?>
					<div class="happyforms-part happyforms-form__part happyforms-payments__price">
						<div class="happyforms-part-wrap">
							<div class="happyforms-part__el" id="<?php happyforms_the_part_id( $part, $form ); ?>_price" data-subpart="price">
								<div class="<?php echo $price_class; ?>"><span><?php echo $currency_symbol; ?></span><strong><?php echo $part['price']; ?></strong></div>
								<?php if ( happyforms_is_truthy ( $part['accept_coupons'] ) ): ?>
								<div class="discounted-price coupons"><?php echo $discounted_price; ?></div>
								<?php endif; ?>
								<input type="hidden" name="<?php happyforms_the_part_name( $part, $form ); ?>[price]" value="<?php echo $price; ?>" data-default="<?php echo $part['price']; ?>">
							</div>
						</div>
					</div>
					<?php if ( happyforms_is_truthy ( $part['accept_coupons'] ) ): ?>
					<div class="happyforms-part happyforms-form__part happyforms-payments__coupon">
						<div class="happyforms-part__wrap">
							<div class="happyforms-part display-type--block">
								<label for="<?php happyforms_the_part_id( $part, $form ); ?>_coupon" class="happyforms-part__label">
									<span class="label"><?php echo $form['coupon_label']; ?></span>
								</label>
								<div class="happyforms-part__el">
									<div class="happyforms-input">
										<input id="happyforms_payment_coupon" type="text" name="happyforms_payment_coupon" value=""  />
										<button id="happyforms_coupon_apply" class="happyforms-button"><?php echo $form['coupon_apply_label']; ?></button>
										<input type="hidden" name="<?php happyforms_the_part_name( $part, $form ); ?>[coupon]" value="<?php happyforms_the_part_value( $part, $form, 'coupon' ); ?>" data-price="<?php echo $price; ?>" data-discounted>
									</div>
									<div class="happyforms-coupon-notice"></div>
								</div>
							</div>
						</div>
					</div>

					<?php endif; ?>
				<?php else : ?>
					<div class="happyforms-part happyforms-form__part happyforms-payments__user-price">
						<div class="happyforms-part-wrap">
							<div class="happyforms-part__el" data-subpart="user_price">
								<label for="<?php happyforms_the_part_id( $part, $form ); ?>_user_price" class="happyforms-part__label">
									<span class="label"><?php echo $form['user_price_label']; ?></span>
								</label>

								<div class="happyforms-input-group with-prefix">
									<div class="happyforms-input-group__prefix">
										<span><?php echo $currency_symbol; ?></span>
									</div>

									<div class="happyforms-input">
										<input id="<?php happyforms_the_part_id( $part, $form ); ?>_user_price" type="number" min="<?php echo $part['user_price_min']; ?>" step="<?php echo $part['user_price_step']; ?>" name="<?php happyforms_the_part_name( $part, $form ); ?>[price]" value="<?php echo happyforms_get_part_value( $part, $form, 'price' ); ?>" placeholder="<?php echo $part['user_price_placeholder']; ?>" <?php happyforms_the_part_attributes( $part, $form, 'price' ); ?> />
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endif; ?>

				<?php if ( happyforms_payment_part_has_credit_card( $part, $form ) && happyforms_payment_part_has_paypal( $part, $form ) ) : ?>
				<div class="happyforms-part happyforms-form__part happyforms-payments__payment-method-choice">
					<div class="happyforms-part__wrap">
						<?php $payment_method = happyforms_get_part_value( $part, $form, 'payment_method' ); ?>
						<div class="happyforms-part happyforms-part--choice happyforms-part-options-width--full display-type--block" data-subpart="payment_method">
							<label for="<?php happyforms_the_part_id( $part, $form ); ?>_payment_method" class="happyforms-part__label">
								<span class="label"><?php echo $form['payment_method_choice_label']; ?></span>
							</label>
							<div class="happyforms-part__el">
								<div class="happyforms-part__option happyforms-part-option happyforms-payments__choice-stripe">
									<label class="option-label">
										<input type="radio" class="happyforms-visuallyhidden" name="<?php happyforms_the_part_name( $part, $form ); ?>[payment_method]" value="stripe" <?php checked( $payment_method, 'stripe' ); ?>>
										<span class="checkmark">
											<span class="happyforms-radio-circle"></span>
										</span>
										<span class="label-wrap">
											<span class="label"><?php echo $form['stripe_option_label']; ?></span>
										</span>
									</label>
								</div>
								<div class="happyforms-part__option happyforms-part-option happyforms-payments__choice-paypal">
									<label class="option-label">
										<input type="radio" class="happyforms-visuallyhidden" name="<?php happyforms_the_part_name( $part, $form ); ?>[payment_method]" value="paypal" <?php checked( $payment_method, 'paypal' ); ?>>
										<span class="checkmark">
											<span class="happyforms-radio-circle"></span>
										</span>
										<span class="label-wrap">
											<span class="label"><?php echo $form['paypal_option_label']; ?></span>
										</span>
									</label>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php elseif ( happyforms_payment_part_has_credit_card( $part, $form ) ) : ?>
					<input type="hidden" name="<?php happyforms_the_part_name( $part, $form ); ?>[payment_method]" value="stripe" />
				<?php elseif ( happyforms_payment_part_has_paypal( $part, $form ) ) : ?>
					<input type="hidden" name="<?php happyforms_the_part_name( $part, $form ); ?>[payment_method]" value="paypal" />
				<?php endif; ?>

				<?php do_action( 'happyforms_part_input_after', $part, $form ); ?>
			</div>

			<?php 
			$part_name = happyforms_get_part_name( $part, $form );
			$notices = happyforms_get_session()->get_messages( $part_name );

			if ( empty( $notices ) ) {
				$notices[] = array(
					'message' => array(
						'realtime' => '',
					),
				);
			};

			happyforms_the_part_error_message( $notices, $part_name, 'realtime' );
			?>
		</div>
	</div>
</div>
