<?php
$service = happyforms_get_integrations()->get_service( 'stripe' );
$credentials = $service->get_credentials();
$action = happyforms_get_integrations()->integrations_action;
$connected = $service->is_connected();
$mode = $credentials['mode'];
?>
<form class="happyforms-service hf-ajax-submit">
	<div class="happyforms-integrations-notices"><?php do_action( 'happyforms_integrations_print_notices' ); ?></div>
	<div class="widget-content">
	<?php wp_nonce_field( $action ); ?>
	<input type="hidden" name="action" value="<?php echo $action; ?>">
	<input type="hidden" name="service" value="<?php echo $service->id; ?>">
	<div id="happyforms-service-<?php echo $service->id; ?>" class="happyforms-service-integration<?php echo ( $connected ) ? ' enabled' : ''; ?>" data-active-mode="<?php echo $mode; ?>">
		<div class="mode-group">
 			<label for="credentials[stripe][mode]"><?php _e( 'Mode', 'happyforms' ); ?></label>
 			<div class="happyforms-buttongroup">
 				<label for="stipe_live">
 					<input type="radio" id="stipe_live" value="live" name="credentials[stripe][mode]" <?php echo ( 'live' == $mode ) ? 'checked' : ''; ?>/>
 					<span><?php _e( 'Live', 'happyforms' ); ?></span>
 				</label>
 				<label for="stripe_test">
 					<input type="radio" id="stripe_test" value="test" name="credentials[stripe][mode]" <?php echo ( 'test' == $mode ) ? 'checked' : ''; ?>/>
 					<span><?php _e( 'Test', 'happyforms' ); ?></span>
 				</label>
 			</div>
 		</div>
		<div class="happyforms-stripe-block happyforms-stripe-block-live">
			<div class="widget-content <?php if ( $service->is_connected() ) : ?>authenticated<?php endif; ?>">
				<input type="hidden" name="services[]" value="<?php echo $service->id; ?>">
				<?php
				happyforms_credentials_input(
					$service->id,
					'key',
					__( 'Publishable key', 'happyforms' ),
					$credentials['key']
				);
				?>
				<?php
				happyforms_credentials_input(
					$service->id,
					'secret_key',
					__( 'Secret key', 'happyforms' ),
					$credentials['secret_key']
				);
				?>
			</div>
		</div>
		<div class="happyforms-stripe-block happyforms-stripe-block-test">
			<div class="widget-content <?php if ( $service->is_connected() ) : ?>authenticated<?php endif; ?>">
				<input type="hidden" name="services[]" value="<?php echo $service->id; ?>">
				<?php
				happyforms_credentials_input(
					$service->id,
					'test_key',
					__( 'Publishable key', 'happyforms' ),
					$credentials['test_key']
				);
				?>
				<?php
				happyforms_credentials_input(
					$service->id,
					'test_secret_key',
					__( 'Secret key', 'happyforms' ),
					$credentials['test_secret_key']
				);
				?>
			</div>
		</div>
		<div class="happyforms-clipboard-field">
			<label for="credentials[stripe][webhook_endpoint_url]"><?php _e( 'Webhook endpoint URL', 'happyforms' ); ?></label>
			<div class="happyforms-clipboard-field-input-wrapper">
				<input type="text" readonly value="<?php echo $service->webhook_endpoint_url; ?>" />
				<div class="happyforms-clipboard">
					<button type="button" class="button happyforms-clipboard__button" data-value="<?php echo $service->webhook_endpoint_url; ?>"><?php _e( 'Copy to clipboard', 'happyforms' ); ?></button>
					<span aria-hidden="true" class="hidden"><?php _e( 'Copied!', 'happyforms' ); ?></span>
				</div>
			</div>
		</div>
		<div class="happyforms-stripe-webhook-endpoint-secret-key happyforms-stripe-webhook-endpoint-secret-key-live">
			<?php
			happyforms_credentials_input(
				$service->id,
				'webhook_endpoint_secret_key',
				__( 'Webhook endpoint secret key', 'happyforms' ),
				$credentials['webhook_endpoint_secret_key']
			);
			?>
		</div>
		<div class="happyforms-stripe-webhook-endpoint-secret-key happyforms-stripe-webhook-endpoint-secret-key-test">
			<?php
			happyforms_credentials_input(
				$service->id,
				'test_webhook_endpoint_secret_key',
				__( 'Webhook endpoint secret key', 'happyforms' ),
				$credentials['test_webhook_endpoint_secret_key']
			);
			?>
		</div>
	</div>
	<div class="widget-control-actions">
		<div class="alignleft">
			<span class="spinner"></span>
			<input type="submit" class="connected button button-primary widget-control-save right" value="<?php _e( 'Save Changes', 'happyforms' ); ?>">
		</div>
		<br class="clear" />
	</div>
	</div>
</form>
