<?php

class HappyForms_Thrive_Automator_Trigger_Form_Field extends Thrive\Automator\Items\Trigger_Field {

	public static function get_id(): string {
		return 'happyforms/trigger_form_field';
	}

	public static function get_name(): string {
		return 'Form';
	}

	public static function get_description(): string {
		return 'The form that triggers this automation';
	}

	public static function get_placeholder(): string {
		return 'Form';
	}

	public static function get_type(): string {
		return Thrive\Automator\Utils::FIELD_TYPE_SELECT;
	}

	public static function is_ajax_field() {
		return true;
	}

	public static function get_options_callback( $trigger_id, $trigger_data ): array {
		$controller = happyforms_get_form_controller();
		$forms = $controller->get();
		$forms = array_filter( $forms, function( $form ) use( $controller ) {
			if ( 'publish' !== $form['post_status'] ) {
				return false;
			}

			return $controller->get_first_part_by_type( $form, 'email' );
		} );

		$forms = array_map( function( $form ) {
			return [
				'id' => $form['ID'],
				'label' => $form['post_title'],
			];
		}, $forms );

		return $forms;
	}

	public static function get_dummy_value() {
		return 'happyforms-form';
	}

}