<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel de Administración</title>
    <style>
        body {
            background-color: #F9F9F9;
            font-family: Arial, sans-serif;
        }
        .container {
            width: 80%;
            margin: 20px auto;
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h1 {
            text-align: center;
        }
        table {
            width: 100%;
            margin: 20px auto;
            border-collapse: collapse;
        }
        th, td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
    <script>
        function confirmDeletion(rut) {
            const answer = confirm("¿Estás seguro de que deseas eliminar este usuario?");
            if (answer) {
                window.location = 'delete_user.php?rut=' + rut;
            }
        }
    </script>
</head>
<body>
    <div class="container">
        <h1>Registro de Usuarios</h1>
        <table>
            <tr>
                <th>Nombre</th>
                <th>Rut</th>
                <th>Correo</th>
                <th>Fono</th>
                <th>Dirección</th>
                <th>Ciudad</th>
                <th>Local</th>
                <th>Profesión</th>
                <th>Ingresos</th>
                <th>Acción</th>
            </tr>
            <?php
            $host = 'localhost';
            $dbUsername = 'anet_re';
            $dbPassword = 'reserva2020';
            $dbName = 'anet_re';

            $conn = new mysqli($host, $dbUsername, $dbPassword, $dbName);
            if ($conn->connect_error) {
                die("Connection failed: " . $conn->connect_error);
            }
            $conn->set_charset("utf8");

            $sql = "SELECT r.nombre, r.rut, r.correo, r.fono, r.direccion, r.ciudad, r.local, r.rol, COUNT(a.id) AS ingresos
                    FROM registros r
                    LEFT JOIN asistencias a ON r.rut = a.rut
                    GROUP BY r.nombre, r.rut, r.correo, r.fono, r.direccion, r.ciudad, r.local, r.rol";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>
                        <td>" . htmlspecialchars($row['nombre']) . "</td>
                        <td>" . htmlspecialchars($row['rut']) . "</td>
                        <td>" . htmlspecialchars($row['correo']) . "</td>
                        <td>" . htmlspecialchars($row['fono']) . "</td>
                        <td>" . htmlspecialchars($row['direccion']) . "</td>
                        <td>" . htmlspecialchars($row['ciudad']) . "</td>
                        <td>" . htmlspecialchars($row['local']) . "</td>
                        <td>" . htmlspecialchars($row['rol']) . "</td>
                        <td>" . $row['ingresos'] . "</td>
                        <td><button onclick='confirmDeletion(\"" . htmlspecialchars($row['rut']) . "\")'>Eliminar</button></td>
                    </tr>";
                }
            } else {
                echo "<tr><td colspan='10'>No hay registros para mostrar</td></tr>";
            }
            $conn->close();
            ?>
        </table>
    </div>
</body>
</html>
