<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Asistencia de Usuarios</title>
    <style>
        body {
            background-color: #F9F9F9;
            font-family: Arial, sans-serif;
        }
        .container {
            width: 80%;
            margin: 20px auto;
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h1 {
            text-align: center;
        }
        table {
            width: 100%;
            margin: 20px auto;
            border-collapse: collapse;
        }
        th, td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
        }
        button {
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #4CAF50; /* Green */
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Asistencia de Usuarios</h1>
        <button onclick="window.location.href='export_asistencia.php'">Exportar a Excel</button>
        <table>
            <tr>
                <th>Nombre</th>
                <th>Correo</th>
                <th>Ciudad</th>
                <th>Local</th>
                <th>Ingresos</th>
            </tr>
            <?php
            $host = 'localhost';
            $dbUsername = 'anet_re';
            $dbPassword = 'reserva2020';
            $dbName = 'anet_re';

            $conn = new mysqli($host, $dbUsername, $dbPassword, $dbName);
            if ($conn->connect_error) {
                die("Connection failed: " . $conn->connect_error);
            }
            $conn->set_charset("utf8");

            $sql = "SELECT r.nombre, r.correo, r.ciudad, r.local, COUNT(a.id) AS ingresos
                    FROM registros r
                    LEFT JOIN asistencias a ON r.correo = a.correo
                    GROUP BY r.nombre, r.correo, r.ciudad, r.local";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>
                        <td>" . htmlspecialchars($row['nombre']) . "</td>
                        <td>" . htmlspecialchars($row['correo']) . "</td>
                        <td>" . htmlspecialchars($row['ciudad']) . "</td>
                        <td>" . htmlspecialchars($row['local']) . "</td>
                        <td>" . $row['ingresos'] . "</td>
                    </tr>";
                }
            } else {
                echo "<tr><td colspan='5'>No hay registros para mostrar</td></tr>";
            }
            $conn->close();
            ?>
        </table>
    </div>
</body>
</html>

