<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Reproductor de Video y Chat</title>
<style>
    body {
        background-color: #F9F9F9; /* Color de fondo */
        margin: 0;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
    }
    .container {
        display: flex;
        flex-direction: column;
        width: 100%;
        align-items: center;
    }
    .video-player, .chat {
        width: 100%; /* Ocupan todo el ancho en mviles */
        height: auto; /* Altura automtica para mantener la proporcin */
    }
    .video-player {
        max-width: 1280px; /* Mximo ancho del video */
        max-height: 480px; /* Mxima altura del video */
    }
    .chat {
        max-width: 1280px; /* Corregido: Mximo ancho del chat */
        max-height: 480px; /* Mxima altura del chat */
    }
    @media (min-width: 768px) {
        .container {
            flex-direction: row; /* Cambia a disposicin en fila para pantallas ms grandes */
        }
        .video-player {
            width: 70%; /* El video ocupa el 70% del ancho en pantallas grandes */
            height: 480px; /* Altura fija para el video */
        }
        .chat {
            width: 30%; /* El chat ocupa el 30% del ancho en pantallas grandes */
            height: 480px; /* Altura fija para el chat */
        }
    }
</style>
</head>
<body>
<div class="container">
    <div class="video-player">
        <!-- Enlace de video incrustado de Vimeo -->
        <iframe src="https://vimeo.com/event/4301392/embed" style="width:100%; height:100%;" frameborder="0" allowfullscreen></iframe>
    </div>
    <div class="chat">
        <!-- Iframe del chat -->
        <iframe src="https://vimeo.com/live/interaction_tools/live_event/4301392?module=auto&amp;theme=light" style="width:100%; height:100%;" frameborder="0"></iframe>
    </div>
</div>
</body>
</html>