<?php
ob_start(); // Inicia el buffer de salida para manejar los headers correctamente
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require '/home/anet/vendor/autoload.php'; // Ruta al autoloader de Composer

// Recuperar datos del formulario
$nombre = $_POST['nombre'] ?? 'Nombre no especificado';
$rut = $_POST['rut'] ?? 'RUT no especificado';
$correo = $_POST['correo'] ?? 'Correo no especificado';
$fono = $_POST['fono'] ?? 'Teléfono no especificado';
$direccion = $_POST['direccion'] ?? 'Dirección no especificada';
$ciudad = $_POST['ciudad'] ?? 'Ciudad no especificada';
$local = $_POST['local'] ?? 'Local no especificado'; // Nuevo campo Local
// Correctly handle the 'rol' field whether it is an array or a single value
$rol = $_POST['rol'] ?? 'Rol no especificado';
$roles = is_array($rol) ? implode(', ', $rol) : $rol;

// Configuración de la conexión a la base de datos
$host = 'localhost';
$dbUsername = 'anet_re';
$dbPassword = 'reserva2020';
$dbName = 'anet_re';

$conn = new mysqli($host, $dbUsername, $dbPassword, $dbName);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

$stmt = $conn->prepare("INSERT INTO registros (nombre, rut, correo, fono, direccion, ciudad, local, rol) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssssss", $nombre, $rut, $correo, $fono, $direccion, $ciudad, $local, $roles);

if ($stmt->execute()) {
    $mail = new PHPMailer(true);
    $mail->CharSet = 'UTF-8'; // Codificación de caracteres

    // Configuración del servidor SMTP
    $mail->isSMTP();
    $mail->Host = 'mail.anet.cl';
    $mail->SMTPAuth = true;
    $mail->Username = 'reservas@anet.cl';
    $mail->Password = 'reservas2020';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port = 465;

    $mail->setFrom('reservas@anet.cl', 'Registro CERTIFICACION BY LAROCHE-POSAY');
    $mail->addAddress($correo, $nombre);

    // Contenido del email
    $mail->isHTML(true);
    $mail->Subject = 'CERTIFICACION BY LAROCHE-POSAY';
    $mail->Body = obtenerCuerpoDelCorreo($nombre, $rut, $fono, $direccion, $ciudad, $local, $roles);

    try {
        $mail->send();
    } catch (Exception $e) {
        error_log('Mailer Error: ' . $mail->ErrorInfo);
    }

    // Redirección a la página de confirmación
    header("Location: registro_exitoso.php?nombre=" . urlencode($nombre) . "&correo=" . urlencode($correo) . "&rut=" . urlencode($rut));
    exit();
} else {
    echo "Error: " . $stmt->error;
}

$conn->close();

// Función para generar el cuerpo del correo electrónico
function obtenerCuerpoDelCorreo($nombre, $rut, $fono, $direccion, $ciudad, $local, $rol) {
    $eventTitle = "CERTIFICACION BY LAROCHE-POSAY 2024";
    $eventDescription = "Certificación oficial por La Roche-Posay.";
    $eventLocation = "Registro CERTIFICACION BY LAROCHE-POSAY";
    $eventDate = "20240516T160000Z/20240516T180000Z";

    $googleLink = "https://www.google.com/calendar/render?action=TEMPLATE&text=" . urlencode($eventTitle) .
        "&dates=$eventDate&details=" . urlencode($eventDescription) .
        "&location=" . urlencode($eventLocation) . "&sf=true&output=xml";
    $outlookLink = "https://outlook.live.com/calendar/0/deeplink/compose?path=/calendar/action/compose&rru=addevent&subject=" . urlencode($eventTitle) .
        "&startdt=$eventDate&enddt=$eventDate&body=" . urlencode($eventDescription) .
        "&location=" . urlencode($eventLocation);

    return "
    <html>
    <head>
    <title>Confirmación de Registro</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 14px; }
        h1 { color: #333; }
        .bold { font-weight: bold; }
        .footer { margin-top: 20px; font-size: 12px; font-weight: bold; }
    </style>
    </head>
    <body>
    <img src='https://anet.cl/re/ca.jpeg' alt='Cabecera' style='width: 700px; height: 100px;'>
    <h1>Registro Completado</h1>
    <p>Hola <span class='bold'>$nombre</span>,</p>
    <p>Gracias por registrarte. Aquí están los detalles de tu registro:</p>
    <ul>
        <li><span class='bold'>RUT:</span> $rut</li>
        <li><span class='bold'>Fono:</span> $fono</li>
        <li><span class='bold'>Dirección:</span> $direccion</li>
        <li><span class='bold'>Ciudad:</span> $ciudad</li>
        <li><span class='bold'>Local:</span> $local</li> <!-- Incluido el campo Local -->
        <li><span class='bold'>Rol:</span> $rol</li>
    </ul>
    <div class='footer'>
        CERTIFICACION BY LAROCHE-POSAY 2024<br>DERMATOLOGÍA QUE CAMBIA VIDAS<br>
        Fecha 16 de Mayo 16 Hrs.<br>
        Agregar a tu Calendario
        <br><br>
        <a href='$googleLink' target='_blank'>Agregar a Google Calendar</a>
        <br>
        <a href='$outlookLink' target='_blank'>Agregar a Outlook Calendar</a>
    </div>
    </body>
    </html>
    ";
}
?>

