<?php
require '/home/anet/vendor/autoload.php'; // Ajusta esta ruta al autoloader de Composer

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

// Especifica la forma de manejar los valores de las celdas como cadenas para conservar la codificación UTF-8
Cell::setValueBinder(new class extends \PhpOffice\PhpSpreadsheet\Cell\StringValueBinder {
    public function bindValue(Cell $cell, $value)
    {
        if (is_string($value)) {
            $cell->setValueExplicit($value, DataType::TYPE_STRING);
            return true;
        }
        return parent::bindValue($cell, $value);
    }
});

$host = 'localhost';
$dbUsername = 'anet_ve';
$dbPassword = 'reserva2020';
$dbName = 'anet_ve';

$conn = new mysqli($host, $dbUsername, $dbPassword, $dbName);
$conn->set_charset("utf8mb4");  // Asegurarse de que la conexión use utf8mb4
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$query = "SELECT nombre, rut, correo, fono, direccion, ciudad, local, rol FROM registros";
$result = $conn->query($query);

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Establecer los encabezados de la hoja
$sheet->setCellValue('A1', 'Nombre');
$sheet->setCellValue('B1', 'Rut');
$sheet->setCellValue('C1', 'Correo');
$sheet->setCellValue('D1', 'Fono');
$sheet->setCellValue('E1', 'Direccion');
$sheet->setCellValue('F1', 'Ciudad');
$sheet->setCellValue('G1', 'Local');
$sheet->setCellValue('H1', 'Profesion');

$row = 2; // Comenzar en la segunda fila porque la primera tiene los encabezados
while ($data = $result->fetch_assoc()) {
    $sheet->setCellValue('A' . $row, $data['nombre']);
    $sheet->setCellValue('B' . $row, $data['rut']);
    $sheet->setCellValue('C' . $row, $data['correo']);
    $sheet->setCellValue('D' . $row, $data['fono']);
    $sheet->setCellValue('E' . $row, $data['direccion']);
    $sheet->setCellValue('F' . $row, $data['ciudad']);
    $sheet->setCellValue('G' . $row, $data['local']);
    $sheet->setCellValue('H' . $row, $data['rol']);
    $row++;
}

$writer = new Xlsx($spreadsheet);

// Redirigir la salida a un cliente web (navegador)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Registros-Cruz-Verde.xlsx"');
header('Cache-Control: max-age=0');

$writer->save('php://output'); // Enviar el archivo Excel generado al navegador
exit;
?>