<?php
/**
 * EAuthUserIdentity class file.
 *
 * @author Maxim Zemskov <nodge@yandex.ru>
 * @link http://code.google.com/p/yii-eauth/
 * @license http://www.opensource.org/licenses/bsd-license.php
 */

/**
 * EAuthUserIdentity is a base User Identity class to authenticate with EAuth.
 * @package application.extensions.eauth
 */
class EAuthUserIdentity extends CBaseUserIdentity {
	const ERROR_NOT_AUTHENTICATED = 3;

	/**
	 * @var EAuthServiceBase the authorization service instance.
	 */
	protected $service;
	
	/**
	 * @var string the unique identifier for the identity.
	 */
	protected $id;
	
	/**
	 * @var string the display name for the identity.
	 */
	public $serviceName;
	public $name;
	protected $firstName;
	protected $email;
	protected $mobilePhone;
	protected $homePhone;
	
	/**
	 * Constructor.
	 * @param EAuthServiceBase $service the authorization service instance.
	 */
	public function __construct($service) {
		$this->service = $service;	
		$this->serviceName = $service->name;
	}
	
	/**
	 * Authenticates a user based on {@link service}.
	 * This method is required by {@link IUserIdentity}.
	 * @return boolean whether authentication succeeds.
	 */
	public function authenticate() {	
		if ($this->service->isAuthenticated) {
			$this->id = $this->service->id;
			$this->name = $this->service->getAttribute('name');
			
			$this->firstName = $this->service->getAttribute('firstName');
			$this->email = $this->service->getAttribute('email');
			$this->mobilePhone = $this->service->getAttribute('mobilePhone');
			$this->homePhone = $this->service->getAttribute('homePhone');
			
			/*$this->setState('id', $this->id);
			$this->setState('service', $this->service->serviceName);
			
			$this->setState('firstName', $this->firstName);
			$this->setState('email', $this->email);
			$this->setState('mobile_phone', $this->mobilePhone);
			$this->setState('home_phone', $this->homePhone);*/
			
			$this->errorCode = self::ERROR_NONE;		
		}
		else {
			$this->errorCode = self::ERROR_NOT_AUTHENTICATED;
		}
		return !$this->errorCode;
	}

	/**
	 * Returns the unique identifier for the identity.
	 * This method is required by {@link IUserIdentity}.
	 * @return string the unique identifier for the identity.
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * Returns the display name for the identity.
	 * This method is required by {@link IUserIdentity}.
	 * @return string the display name for the identity.
	 */	
	public function getName() {
		return $this->name;
	}
	
	public function getFirstName() {
		return $this->firstName;
	}
	
	public function getEmail() {
		return $this->email;
	}
	
	public function getMobilePhone() {
		return $this->mobilePhone;
	}
	
	public function getHomePhone() {
		return $this->homePhone;
	}
}