<?php 

require_once(_PS_MODULE_DIR_."flowpaymentwp/lib/flowapiwp.php");

class FlowPaymentWPPaymentCreateModuleFrontController extends ModuleFrontController{

    protected $paymentMediumName;
    
    public function __construct(){
        $this->paymentMediumName = 'webpay';
        parent::__construct();
    }

    public function initContent(){
        
        try{

            Logger::addLog('Entering the create payment method');
            $cart = $this->context->cart;
            $customer = $this->context->customer;
            $currency = $this->context->currency;
            $currencyName = $currency->iso_code;
            
            $allowedCurrencies = array(
                'CLP'
            );
            
            if(!in_array($currencyName, $allowedCurrencies)){
                throw new Exception("The currency $currencyName is not supported by Flow");
            }
            
            $amount = $cart->getOrderTotal(true, Cart::BOTH);
            $additionalAmount = round(($amount * Configuration::get('FLOW_WP_RECHARGE'))/100.0);
            $finalAmount = (int) ($amount + $additionalAmount);
            
            //Creating the order
            $this->module->validateOrder(
                $cart->id,
                Configuration::get("FLOW_PAYMENT_PENDING"),
                $amount,
                $this->module->displayName,
                null,
                array(),
                (int)$currency->id,
                false,
                $cart->secure_key
            );
            
            $order = new Order(Order::getOrderByCartId($cart->id));
            
            $commerceOrder = $order->id;
            $subject = html_entity_decode('Orden #'.$commerceOrder.' de '.Configuration::get('PS_SHOP_NAME'), ENT_QUOTES, 'UTF-8');
            $userEmail = $customer->email;
            $urlConfirmation = $this->context->link->getModuleLink('flowpaymentwp', 'confirmation', array());
            $urlReturn = $this->context->link->getModuleLink('flowpaymentwp', 'return', array());
            
            
            //TODO check for CLP currency
            $params = array(
                "commerceOrder" => $commerceOrder, 
                "subject" => $subject, 
                "currency" => "CLP", 
                "amount" => $finalAmount, 
                "email" => $userEmail, 
                "paymentMethod" => $this->getPaymentMedium($this->paymentMediumName), 
                "urlConfirmation" => $urlConfirmation, 
                "urlReturn" => $urlReturn,
            );

            if($additionalAmount > 0){
                $params['optional'] = json_encode(array(
                    'Monto compra' => number_format($amount, 0, ',', '.'). ' CLP',
                    'Recargo comercio' => number_format($additionalAmount, 0, ',', '.'). ' CLP'
                ));
            }
            
            $apiKey = Configuration::get('FLOW_WP_API_KEY');
            $secretKey = Configuration::get('FLOW_WP_SECRET_KEY');
            $mode = Configuration::get('FLOW_WP_MODE');
            $endpoint = $mode == 'TEST' ? 'https://sandbox.flow.cl/api' : 'https://www.flow.cl/api';
            $service = 'payment/create';
            
            Logger::addLog('Calling Flow Service: '.$service. ' With params: '.json_encode($params));
            $flowApi = new FlowApiWP($apiKey, $secretKey, $endpoint);
           
            $method = 'POST';

            $response = $flowApi->send($service, $params, $method);
            $urlToRedirect = $response['url'].'?token='.$response['token'];

            header('Location: '.$urlToRedirect);
            die();
            
        }catch(\Exception $e){
            Logger::addLog('There\'s been an unexpected error: '.$e->getCode(). ' - '.$e->getMessage());
            Tools::redirect($this->context->link->getModuleLink('flowpaymentwp', 'error', array()));
        }
    }

    private function getPaymentMedium($name){

        switch($name) {
            
            case 'webpay': {
                $paymentMedium = 1;
                break;
            }
            case 'servipag': {
                $paymentMedium = 2;
                break;
            }
            case 'multicaja': {
                $paymentMedium = 3;
                break;
            }
            case 'onepay': {
                $paymentMedium = 5;
                break;
            }
            case 'cryptocompra': {
                $paymentMedium = 8;
                break;
            }
            case 'flow': {
                $paymentMedium = 9;
                break;
            }
            default: {
                $paymentMedium = 1;
                break;
            }
        }

        return $paymentMedium;
    }
}