<?php

//If we're being hacked somehow
if(!defined('_PS_VERSION_')){
    exit;
}

class FlowPaymentWP extends PaymentModule{

    protected $paymentMediumName;

    public function __construct(){

        $this->paymentMediumName = 'webpay';
        $this->name = 'flowpaymentwp';
        $this->author = 'flow';
        $this->version = '2.0';
        $this->tab = 'payments_gateways';
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Flow Webpay');
        $this->description = $this->l('Pago usando Flow Webpay');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall this module?');
    }

    public function install(){

        if(!parent::install() || !$this->registerHook('payment') || !$this->registerHook('displayPaymentReturn')){
            return false;
        }
        
        //If the custom status is not yet installed, we add right here, right now, right here, right now.
        if(!Configuration::get('FLOW_PAYMENT_PENDING')){
            $orderState = new OrderState();
            $orderState->name = array();
            $orderState->module_name = $this->name;
            $orderState->send_email = false;
            $orderState->color = 'blue';
            $orderState->hidden = false;
            $orderState->delivery = false;
            $orderState->logable = false;
            $orderState->invoice = false;
            $orderState->paid = false;

            foreach (Language::getLanguages() as $language) {
                $orderState->template[$language['id_lang']] = 'payment';
                $orderState->name[$language['id_lang']] = 'Pending Payment';
            }

            if(!$orderState->add()){
                return false;
            }

            Configuration::updateValue('FLOW_PAYMENT_PENDING', (int)$orderState->id);
        }
        return true;
    }
    
    public function uninstall(){
        
        if(!parent::uninstall()){
            return false;
        }
        
        Configuration::deleteByName('FLOW_WP_PAYMENT_NAME');
        Configuration::deleteByName('FLOW_WP_API_KEY');
        Configuration::deleteByName('FLOW_WP_SECRET_KEY');
        Configuration::deleteByName('FLOW_WP_MODE');
        Configuration::deleteByName('FLOW_WP_RECHARGE');
        Configuration::deleteByName('FLOW_WP_URL_RETURN');
        
        return true;
    }

    public function getContent(){
        
        $output = null;
        $path = dirname(__FILE__);
        $customLogoDirPath = $path."/views/img";
        
        if (is_writable($customLogoDirPath) && !file_exists($customLogoDirPath."/custom-logo-small.png")) {
            copy("$customLogoDirPath/logo-small.png", "$customLogoDirPath/custom-logo-small.png");
        }
        
        //If the form was submitted
        if(Tools::isSubmit('submit'.$this->name)){

            $name = Tools::getValue('FLOW_WP_PAYMENT_NAME');
            $apiKey = Tools::getValue('FLOW_WP_API_KEY');
            $secretKey = Tools::getValue('FLOW_WP_SECRET_KEY');
            $mode = Tools::getValue('FLOW_WP_MODE');
            $recharge = Tools::getValue('FLOW_WP_RECHARGE');
            $valid = true;

            if(empty($name)){
                $output.= $this->displayError($this->l('El nombre es requerido'));
                $valid = false;
            }
            if(empty($apiKey)){
                $output.= $this->displayError($this->l('La llave de Api es requerida'));
                $valid = false;
            }
            if(empty($secretKey)){
                $output.= $this->displayError($this->l('La llave secreta es requeida'));
                $valid = false;
            }

            if($valid){

                Configuration::updateValue('FLOW_WP_PAYMENT_NAME', $name);
                Configuration::updateValue('FLOW_WP_MODE', $mode);
                Configuration::updateValue('FLOW_WP_API_KEY', $apiKey);
                Configuration::updateValue('FLOW_WP_SECRET_KEY', $secretKey);
                Configuration::updateValue('FLOW_WP_RECHARGE', $recharge);
                
                //TODO: Resize the image
                if(!empty($_FILES['FLOW_LOGO'])){
                    $file = $_FILES['FLOW_LOGO'];
                    if(is_writable($customLogoDirPath)){
                        move_uploaded_file($file['tmp_name'], $customLogoDirPath."/custom-logo-small.png");
                    }
                    else{
                        $output.= $this->displayError($this->l('El directorio del logo no es escribible.'));
                    }
                }

                if($this->paymentMediumName != 'webpay' && $this->paymentMediumName != 'onepay'){
                    Configuration::updateValue('FLOW_WP_URL_RETURN', Tools::getValue('FLOW_WP_URL_RETURN'));
                }

                $output.= $this->displayConfirmation($this->l('Settings updated'));
            }
        }

        return $output.$this->displayForm();
    }

    public function displayForm(){

        // Get default language
        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Settings'),
            ),
            'input' => array(
                array(
                    'type'      =>  'select',
                    'label'     =>  $this->l('Plataforma de flow'),
                    'name'      =>  'FLOW_WP_MODE',
                    'required'  =>  true,
                    'options'   =>  array(
                        'query' => array(
                            array(
                                'id_option'     =>  'TEST',
                                'name'          =>  $this->l('Plataforma sandbox Flow')
                            ),
                            array(
                                'id_option'     =>  'PROD',
                                'name'          =>  $this->l('Plataforma de producción Flow')
                            )
                        ),
                        'id'    =>  'id_option',
                        'name'  =>  'name'
                    )
                ),
                array(
                    'type'      =>  'text',
                    'label'     =>  $this->l('Nombre del medio de pago'),
                    'name'      =>  'FLOW_WP_PAYMENT_NAME',
                    'size'      =>  20,
                    'required'  =>  true,
                ),
                array(
                    'type'      =>  'text',
                    'label'     =>  $this->l('Api Key'),
                    'name'      =>  'FLOW_WP_API_KEY',
                    'required'  =>  true,
                ),
                array(
                    'type'      =>  'text',
                    'label'     =>  $this->l('Secret Key'),
                    'name'      =>  'FLOW_WP_SECRET_KEY',
                    'required'  =>  true,
                ),
                array(
                    'type'      =>  'text',
                    'label'     =>  $this->l('Cobro adicional'),
                    'name'      =>  'FLOW_WP_RECHARGE',
                    'required'  =>  false,
                    'desc'      =>  $this->l('En %')
                ),
                array(
                    'type'      =>  'file',
                    'label'     =>  $this->l('Logo'),
                    'name'      =>  'FLOW_LOGO'
                )
            ),
            'submit'    =>  array(
                'title'     =>  $this->l('Save'),
                'class'     =>  'btn btn-default pull-right',
            )
        );

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;

        $helper->title = $this->displayName;
        $helper->show_toolbar = true;        // false -> remove toolbar
        $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
        $helper->submit_action = 'submit'.$this->name;

        $helper->toolbar_btn = array(
            'save' =>
            array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                '&token='.Tools::getAdminTokenLite('AdminModules'),
            ),
            'back' => array(
                'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list')
            )
        );

        // Load current value
        $helper->fields_value['FLOW_WP_PAYMENT_NAME'] = Configuration::get('FLOW_WP_PAYMENT_NAME');
        $helper->fields_value['FLOW_WP_MODE'] = Configuration::get('FLOW_WP_MODE');
        $helper->fields_value['FLOW_WP_API_KEY'] = Configuration::get('FLOW_WP_API_KEY');
        $helper->fields_value['FLOW_WP_SECRET_KEY'] = Configuration::get('FLOW_WP_SECRET_KEY');
        $helper->fields_value['FLOW_WP_RECHARGE'] = Configuration::get('FLOW_WP_RECHARGE');

         //If this is not webpay.
         if($this->paymentMediumName != 'webpay' && $this->paymentMediumName != 'onepay'){

            array_push($fields_form[0]['form']['input'], array(
                'type'      =>  'text',
                'label'     =>  $this->l('Url de retorno'),
                'name'      =>  'FLOW_WP_URL_RETURN',
                'required'  =>  false,
            ));

           $helper->fields_value['FLOW_WP_URL_RETURN'] = Configuration::get('FLOW_WP_URL_RETURN');
        }
        return $helper->generateForm($fields_form);
    }

    public function hookPayment($params){
        
        $customLogoDirPath = dirname(__FILE__)."/views/img";
        if(file_exists($customLogoDirPath."/custom-logo-small.png")){
            $logoUrl = Tools::getShopDomainSsl(true, true). __PS_BASE_URI__. 'modules/'.$this->name."/views/img/custom-logo-small.png";
        }
        else{
            $logoUrl = Tools::getShopDomainSsl(true, true). __PS_BASE_URI__. 'modules/'.$this->name."/views/img/logo-small.png";
        }
        
        $this->context->smarty->assign(
            array(
                'logo'  =>  $logoUrl
            )
        );
        return $this->display(__FILE__, 'views/templates/hook/displayPayment.tpl');
    }

    /**
     * Hook called when the customer returns from the payment gateway. 
     * Here we display our custom messages.
     *
     * @param mixed $params
     * @return void
     */
    public function hookDisplayPaymentReturn($params){

        $order = $params['objOrder'];
        $status = $order->current_state == Configuration::get('PS_OS_PAYMENT') ? 'successful' : 'failed';

        $this->context->smarty->assign(array(
            'status'    =>  $status
        ));
        
        return $this->display(__FILE__, 'views/templates/hook/displayPaymentReturn.tpl');
    }
     
    private function getPaymentMedium($name){

        switch($name) {
            
            case 'webpay': {
                $paymentMedium = 1;
                break;
            }
            case 'servipag': {
                $paymentMedium = 2;
                break;
            }
            case 'multicaja': {
                $paymentMedium = 3;
                break;
            }
            case 'onepay': {
                $paymentMedium = 5;
                break;
            }
            case 'cryptocompra': {
                $paymentMedium = 8;
                break;
            }
            case 'flow': {
                $paymentMedium = 9;
                break;
            }
            default: {
                $paymentMedium = 1;
                break;
            }
        }

        return $paymentMedium;
    }

    public function getPaymentMediumName(){
        return $this->paymentMediumName;
    }
    
}