<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Galería de Fotos</title>

    <style>
        .foto-container {
            margin-bottom: 20px;
        }

        .descargar-link {
            display: block;
            margin-top: 10px;
        }

        img {
            width: 10%;
        }
    </style>
</head>
<body>

    <h1>Galería de Fotos</h1>

    <?php
    $directorioDestino = "fotos/";
    $fotos = glob($directorioDestino . "*.{jpg,jpeg,png,gif}", GLOB_BRACE);

    foreach ($fotos as $foto) {
        $nombreArchivo = basename($foto);
        $nombreUsuario = obtenerNombreUsuario($nombreArchivo);

        echo "<div class='foto-container'>";
        echo "<a href='$foto' download>";
        echo "<img src='$foto' alt='Foto'>";
        echo "</a>";
        echo "<p>Nombre: $nombreUsuario</p>";
        echo "<a class='descargar-link' href='$foto' download>Descargar</a>";
        echo "</div>";
    }
    ?>

    <?php
    function obtenerNombreUsuario($nombreArchivo) {
        $posicionGuionBajo = strpos($nombreArchivo, '_');
        
        if ($posicionGuionBajo !== false) {
            return substr($nombreArchivo, 0, $posicionGuionBajo);
        } else {
            return "UsuarioDesconocido";
        }
    }
    ?>

</body>
</html>

