<?php  
/**
 * Configuration for the Kirki Customizer.
 * @package Kirki
 */

if(!function_exists('astroidz_kirki_sections')){
	add_action( 'customize_register', 'astroidz_kirki_sections' );
	function astroidz_kirki_sections( $wp_customize ) {
		/**
		 * Background settings with sub panel ============================================================
		 */
		$wp_customize->add_panel( 'astroidz_panel', array(
			'title'       => esc_html__( 'Astroidz background settings', "astroidz" ),
			'priority'    => 60
		));

			$wp_customize->add_section( 'astroidz_options_section', array(
				'title'       => __( 'Global options', 'astroidz' ),
				'panel'          => 'astroidz_panel', // Not typically needed.
				'priority'       => 0,
			));

			$wp_customize->add_section( 'astroidz_colors_section', array(
				'title'       => __( 'Background colors', 'astroidz' ),
				'description' => __( 'Manage Background colors', 'astroidz' ),
				'panel'          => 'astroidz_panel', // Not typically needed.
				'priority'       => 0,
			));

			$wp_customize->add_section( 'astroidz_lights_section', array(
				'title'       => __( 'Lights', 'astroidz' ),
				'description' => __( 'Manage lights', 'astroidz' ),
				'panel'          => 'astroidz_panel', // Not typically needed.
				'priority'       => 0,
			));
			$wp_customize->add_section( 'astroidz_materials_section', array(
				'title'       => __( 'Materials', 'astroidz' ),
				'description' => __( 'Manage materials', 'astroidz' ),
				'panel'          => 'astroidz_panel', // Not typically needed.
				'priority'       => 0,
			));
			
	}
}

