<?php  

Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'QT_timing_settings',
	'label'       => esc_html__( 'Time format', 'proradio' ),
	'description' => esc_html__( 'Change the time format used for the shows in frontend', "proradio" ),
	'section'     => 'proradio_schedule_settings',
	'default'     => '12',
	'priority'    => 10,
	'multiple'    => false,
	'choices'     => array(
			'12'   	=> esc_attr__( '12 Hours format', 'proradio' ),
			'24'   	=> esc_attr__( '24 Hours format', 'proradio' ),
		)
) );




Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'proradio_timetable_limit',
	'label'       => esc_html__( 'Time table limit in single show page', "proradio" ),
	'description' => esc_html__( 'In single show page, limit number of shows in the timetable and add an expand button', "proradio" ),
	'section'     => 'proradio_schedule_settings',
	'default'     => 0,
	'priority'    => 10,
	'multiple'    => false,
	'choices'     => array(
			0   	=> esc_attr__( 'Disabled - show all entries', 'proradio' ),
			3   	=> esc_attr__( '3 Entries', 'proradio' ),
			5   	=> esc_attr__( '5 Entries', 'proradio' ),
		)
) );


/* = Main colors
=============================================*/
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'timetable_bg',
	'label'       => esc_html__( 'Timetable section background in single show page', "proradio" ),
	'section'     => 'proradio_schedule_settings',
	'transport'   => 'auto',
	'priority'    => 0,
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-showscheduled .proradio-primary-dark',
			'property'      => 'background-color',
		),
	),
));

Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'timetable_padding',
	'label'       => esc_html__( 'Inner menu padding', 'proradio' ),
	'section'     => 'proradio_schedule_settings',
	'default'     => [
		'padding-top'    => '0px',
		'padding-bottom' => '0px',
		'padding-left'   => '0px',
		'padding-right'  => '0px',
	],
	'transport'   => 'auto',
	'output'    => array(
		array(
			 'choice'      => 'padding-top',
			'element'       => '.proradio-showscheduled .proradio-container',
			'property'      => 'padding-top',
			'media_query' => '@media (min-width: 1200px)'
		),	
		array(
			 'choice'      => 'padding-bottom',
			'element'       => '.proradio-showscheduled .proradio-container',
			'property'      => 'padding-bottom',
			'media_query' => '@media (min-width: 1200px)'
		),

		array(
			 'choice'      => 'padding-left',
			'element'       => '.proradio-showscheduled .proradio-container',
			'property'      => 'padding-left',
			'media_query' => '@media (min-width: 1200px)'
		),

		array(
			 'choice'      => 'padding-right',
			'element'       => '.proradio-showscheduled .proradio-container',
			'property'      => 'padding-right',
			'media_query' => '@media (min-width: 1200px)'
		),	
	),
] );
