<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'show_social_secondaryheader',
	'label'       => esc_html__( 'Display social in secondary header', "proradio" ),
	'section'     => 'proradio_social_header',
	'default'       => 1,
	'priority'    => 1,
));



Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'soc_icons_margin_header',
	'label'       => esc_html__( 'Margin', 'proradio' ),
	'section'     => 'proradio_social_header',
	'transport'   => 'auto',
	'default'		=> 5,
	'choices'     => [
		'min'  => 0,
		'max'  => 20,
		'step' => 1
	],
	'output'    => array(
		array(
			'element'       => '.proradio-secondaryhead .proradio-menubar__secondary li.proradio-social',
			'property'      => 'margin-right',
			'value_pattern' => esc_attr( ' $px;' )
		),
		 array(
			'element'       => '.proradio-secondaryhead .proradio-menubar__secondary li.proradio-social',
			'property'      => 'margin-left',
			'value_pattern' => esc_attr( ' $px;' )
		)
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],


] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'soc_icons_lh_header',
	'label'       => esc_html__( 'Line height', 'proradio' ),
	'section'     => 'proradio_social_header',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0.1,
		'max'  => 3,
		'step' => 0.05
	],
	'output'    => array(
		array(
			'element'       => '.proradio-secondaryhead .proradio-soc-icon',
			'property'      => 'line-height',
			'value_pattern' => esc_attr( ' $em !important;' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'soc_icons_padding_header',
	'label'       => esc_html__( 'Padding', 'proradio' ),
	'section'     => 'proradio_social_header',
	'default'     => 0,
	'transport'   => 'auto',
	'default'     => [
		'padding-top'    => '0px',
		'padding-bottom' => '0px',
		'padding-left'   => '0px',
		'padding-right'  => '0px',
	],
	'output'      => array(
		array(
		  'choice'      => 'padding-top',
		  'element'     => '.proradio-secondaryhead .proradio-social a.proradio-soc-icon',
		  'property'    => 'padding-top',
		),
		array(
		  'choice'      => 'padding-bottom',
		  'element'     => '.proradio-secondaryhead .proradio-social a.proradio-soc-icon',
		  'property'    => 'padding-bottom',
		),
		array(
		  'choice'      => 'padding-left',
		  'element'     => '.proradio-secondaryhead .proradio-social a.proradio-soc-icon',
		  'property'    => 'padding-left',
		),
		array(
		  'choice'      => 'padding-right',
		  'element'     => '.proradio-secondaryhead .proradio-social a.proradio-soc-icon',
		  'property'    => 'padding-right',
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],

] );

/* Border */

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'soc_icons_bw_header',
	'label'       => esc_html__( 'Border', 'proradio' ),
	'section'     => 'proradio_social_header',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 10,
		'step' => 1
	],
	'output'    => array(
		array(
			'element'       => '.proradio-secondaryhead .proradio-soc-icon',
			'property'      => 'border-width',
			'value_pattern' => esc_attr( ' $px;' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],

] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'soc_icons_br_header',
	'label'       => esc_html__( 'Border radius', 'proradio' ),
	'section'     => 'proradio_social_header',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1
	],
	'output'    => array(
		array(
			'element'       => '.proradio-secondaryhead .proradio-soc-icon',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],

] );

/* = Main colors
=============================================*/
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'soc_icons_bg_header',
	'label'       => esc_html__( 'Background', "proradio" ),
	'section'     => 'proradio_social_header',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-secondaryhead .proradio-social a.proradio-soc-icon',
			'property'      => 'background-color',
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'soc_icons_bg_h_header',
	'label'       => esc_html__( 'Background over', "proradio" ),
	'section'     => 'proradio_social_header',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-secondaryhead .proradio-social a.proradio-soc-icon:hover',
			'property'      => 'background-color',
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'soc_icons_color_header',
	'label'       => esc_html__( 'Icon color', "proradio" ),
	'section'     => 'proradio_social_header',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-secondaryhead a.proradio-soc-icon',
			'property'      => 'color',
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'soc_icons_color_h_header',
	'label'       => esc_html__( 'Icon color hover', "proradio" ),
	'section'     => 'proradio_social_header',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-secondaryhead a.proradio-soc-icon:hover',
			'property'      => 'color',
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'show_social_secondaryheader',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
));
