<?php  

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Include the Welcome Page in the menu
 * =============================================*/
if ( ! function_exists( 'proradio_welcome_menupage' ) ) {
	add_action( 'admin_menu', 'proradio_welcome_menupage' );
	function proradio_welcome_menupage() {
		$current_theme = wp_get_theme();
		if( is_child_theme() ){
			$current_theme = $current_theme->parent();
		}
		if(function_exists('proradio_iid')){
			$pid = proradio_iid();
			if($pid == 'pending'){
				// return;
			}
		}
		add_theme_page(
			sprintf( esc_html__( '%s activation and update', 'proradio' ), $current_theme->name ),
			sprintf( esc_html__( '%s activation and updates', 'proradio' ),  $current_theme->name ),
			'manage_options',
			'proradio-welcome',
			'proradio_welcome_page_content'
		);
		
		add_menu_page(
			sprintf( esc_html__( '%s admin', 'proradio' ), $current_theme->name ),
			sprintf( esc_html__( '%s admin', 'proradio' ),  $current_theme->name ),
			'manage_options',
			'proradio-welcome',
			'proradio_welcome_page_content',
			get_theme_file_uri('/img/menu-icon.png' ),
			1 // Order ID
		);


		add_submenu_page(
			'proradio-welcome',
			sprintf( esc_html__( '%s Welcome', 'proradio' ), $current_theme->name ),
			sprintf( esc_html__( 'Welcome', 'proradio' ),  $current_theme->name ),
			'manage_options',
			'proradio-onboarding',
			'proradio_onboarding_page',
			0 // Order ID
		);

		add_submenu_page(
			'proradio-welcome',
			sprintf( esc_html__( 'Proxy switch', 'proradio' ), $current_theme->name ),
			sprintf( esc_html__( 'Proxy switch', 'proradio' ),  $current_theme->name ),
			'manage_options',
			'proradio-proxy',
			'proradio_proxy_switch_page',
			0
		);

		add_submenu_page(
			'proradio-welcome',
			sprintf( esc_html__( '%s  activation and update', 'proradio' ), $current_theme->name ),
			sprintf( esc_html__( '%s activation and update', 'proradio' ),  $current_theme->name ),
			'manage_options',
			'proradio-welcome',
			'proradio_welcome_page_content',
			0 // Order ID
		);

		if(class_exists('OCDI_Plugin')){
			add_submenu_page(
			    'proradio-welcome',
			    esc_html__( 'Import demo data', 'one-click-demo-import' ),
			    esc_html__( 'Import demo data', 'one-click-demo-import' ),
			    'manage_options',
			    'themes.php?page=one-click-demo-import'
			);
		}

		add_submenu_page(
			'proradio-welcome',
			sprintf( esc_html__( '%s Knowledgebase', 'proradio' ), $current_theme->name ),
			sprintf( esc_html__( 'Knowledgebase', 'proradio' ),  $current_theme->name ),
			'manage_options',
			'proradio-manual',
			'proradio_welcome_page_manual',
			1 // Order ID
		);
		add_submenu_page(
			'proradio-welcome',
			sprintf( esc_html__( '%s Clear cache', 'proradio' ), $current_theme->name ),
			sprintf( esc_html__( 'Clear cache', 'proradio' ),  $current_theme->name ),
			'manage_options',
			'proradio-clear-cache',
			'proradio_welcome_page_clear_cache',
			2 // Order ID
		);
		add_submenu_page(
			'proradio-welcome',
			sprintf( esc_html__( '%s Features protection', 'proradio' ), $current_theme->name ),
			sprintf( esc_html__( 'Features protection', 'proradio' ),  $current_theme->name ),
			'manage_options',
			'proradio-elementor-settings',
			'proradio_welcome_page_elementor_settings',
			3 // Order ID
		);
	}	
}