<?php
session_start();
include('bd/db.php'); // Conexión a la base de datos

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $usuario = htmlspecialchars($_POST['usuario']);
    $clave = htmlspecialchars($_POST['clave']);

    // Verificar usuario en la base de datos
    $sql = "SELECT id FROM usuarios_admin WHERE usuario = ? AND clave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $usuario, $clave);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $_SESSION['admin'] = $usuario; // Guardar sesión de administrador
        header('Location: inicio.php'); // Redirigir al dashboard
        exit();
    } else {
        $error = "Usuario o contraseña incorrectos.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administrador - Sistema de Pedidos Musicales</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('img/fo1.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            color: #333;
        }
        .logo-container {
            text-align: center;
            margin-top: 150px; /* Ajustar según necesidad */
        }
        .logo-container img {
            width: 150px;
        }
        .form-container {
            margin-top: 50px;
            text-align: center;
        }
        form {
            display: inline-block;
            background: rgba(255, 255, 255, 0.9);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        form h2 {
            color: #0078D7;
            margin-bottom: 20px;
        }
        form input {
            display: block;
            width: 80%;
            padding: 10px;
            margin: 10px auto;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
        }
        form button {
            background-color: #0078D7;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 20px;
            font-size: 16px;
        }
        form button:hover {
            background-color: #005BB5;
        }
        .error {
            color: red;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="logo-container">
        <img src="img/logo.png" alt="Logo">
    </div>

    <div class="form-container">
        <form action="" method="post">
            <h2>Administrador</h2>
            <input type="text" name="usuario" placeholder="&#128100; Usuario" required>
            <input type="password" name="clave" placeholder="&#128274; Contraseña" required>
            <button type="submit">Iniciar Sesión</button>
            <?php if (isset($error)): ?>
                <p class="error"><?php echo $error; ?></p>
            <?php endif; ?>
        </form>
    </div>
</body>
</html>
