<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}

include('bd/db.php'); // Conexión a la base de datos

// Obtener todas las sesiones guardadas
$sql_sesiones = "SELECT id, nombre_sesion FROM sesiones ORDER BY fecha_guardado DESC";
$result_sesiones = $conn->query($sql_sesiones);

$clientes = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['sesion_id'])) {
    $sesion_id = intval($_POST['sesion_id']);

    // Obtener los clientes de la sesión seleccionada
    $sql_clientes = "SELECT clientes_guardados FROM sesiones WHERE id = ?";
    $stmt_clientes = $conn->prepare($sql_clientes);
    $stmt_clientes->bind_param("i", $sesion_id);
    $stmt_clientes->execute();
    $result_clientes = $stmt_clientes->get_result();

    if ($result_clientes->num_rows > 0) {
        $sesion = $result_clientes->fetch_assoc();
        $clientes = json_decode($sesion['clientes_guardados'], true); // Decodificar los clientes de la sesión
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Juegos - Tómbola</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f0f8ff;
            text-align: center;
            margin: 0;
        }

        h1 {
            color: #333;
            margin-bottom: 20px;
        }

        .form-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 30px;
        }

        select, button {
            padding: 15px;
            font-size: 16px;
            border: none;
            border-radius: 8px;
            margin: 10px 0;
        }

        select {
            width: 60%;
            background-color: #e8f0fe;
            border: 1px solid #0078D7;
        }

        button {
            background-color: #0078D7;
            color: white;
            font-weight: bold;
            cursor: pointer;
        }

        button:hover {
            background-color: #005BB5;
        }

        .tombola-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            padding: 30px;
            max-width: 500px;
            margin: 0 auto 20px;
        }

        .tombola {
            font-size: 1.5em;
            color: #0078D7;
            margin: 20px 0;
            height: 50px;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid #0078D7;
            border-radius: 8px;
        }

        .tombola p {
            animation: none;
        }

        .winner {
            font-size: 1.5em;
            font-weight: bold;
            color: #28a745;
            margin-top: 20px;
            display: none;
        }

        footer {
            background-color: #0078D7;
            color: white;
            padding: 10px 0;
            position: fixed;
            bottom: 0;
            width: 100%;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>

    <h1>Tómbola de Clientes</h1>

    <div class="form-container">
        <form action="" method="post">
            <select name="sesion_id" id="sesion_id" required>
                <option value="">-- Selecciona una sesión --</option>
                <?php while ($row = $result_sesiones->fetch_assoc()): ?>
                    <option value="<?php echo $row['id']; ?>" <?php echo isset($sesion_id) && $sesion_id == $row['id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($row['nombre_sesion']); ?>
                    </option>
                <?php endwhile; ?>
            </select>
            <button type="submit">Cargar Sesión</button>
        </form>
    </div>

    <div class="tombola-container">
        <div class="tombola" id="tombola">
            <p id="names">
                <?php if (!empty($clientes)): ?>
                    <?php foreach ($clientes as $cliente): ?>
                        <?php echo htmlspecialchars($cliente['nombre']) . " (" . htmlspecialchars($cliente['telefono']) . ")<br>"; ?>
                    <?php endforeach; ?>
                <?php else: ?>
                    No hay clientes cargados.
                <?php endif; ?>
            </p>
        </div>
        <button id="sortear">Sortear</button>
        <div class="winner" id="winner">
            🎉 Felicidades, <span id="winner-name"></span>! 🎉
        </div>
    </div>

    <script>
        document.getElementById('sortear').addEventListener('click', function () {
            const namesElement = document.getElementById('names');
            const tombolaElement = document.getElementById('tombola');
            const winnerElement = document.getElementById('winner');
            const winnerNameElement = document.getElementById('winner-name');

            winnerElement.style.display = 'none';

            // Obtener nombres
            const names = namesElement.innerHTML.split('<br>').filter(name => name.trim() !== '');

            if (names.length === 0) {
                namesElement.innerHTML = 'No hay participantes elegibles para el sorteo.';
                return;
            }

            // Iniciar animación rápida de los nombres
            let interval;
            let counter = 0;

            function startTombola() {
                interval = setInterval(() => {
                    namesElement.innerHTML = names[counter];
                    counter = (counter + 1) % names.length;
                }, 100);
            }

            startTombola();

            // Detener la animación y mostrar el ganador
            setTimeout(() => {
                clearInterval(interval);
                const winner = names[Math.floor(Math.random() * names.length)];
                namesElement.innerHTML = winner;
                winnerNameElement.textContent = winner;
                winnerElement.style.display = 'block';
            }, 5000); // Duración de la animación
        });
    </script>

    <footer>
        <p>&copy; 2024 Juegos - Tómbola</p>
    </footer>
</body>
</html>
