<?php
include('adm/bd/db.php'); // Conexión a la base de datos

// Validar que la categoría sea válida y que se haya enviado una consulta
$categoria = 'Musica'; // Esta categoría puede ser dinámica dependiendo de la carpeta
$busqueda = isset($_GET['q']) ? htmlspecialchars(trim($_GET['q'])) : '';

if (empty($busqueda)) {
    echo json_encode([]);
    exit();
}

// Consultar temas en la categoría correspondiente
$sql = "
    SELECT m.tema, m.artista 
    FROM musica m
    INNER JOIN categorias c ON m.categoria_id = c.id
    WHERE c.nombre_categoria = ? AND m.tema LIKE ?
    ORDER BY m.tema ASC
";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode(['error' => $conn->error]);
    exit();
}

$param_busqueda = '%' . $busqueda . '%';
$stmt->bind_param("ss", $categoria, $param_busqueda);
$stmt->execute();
$result = $stmt->get_result();

// Formatear los resultados
$temas = [];
while ($row = $result->fetch_assoc()) {
    $temas[] = [
        'tema' => $row['tema'],
        'artista' => $row['artista']
    ];
}

// Devolver los resultados como JSON
header('Content-Type: application/json');
echo json_encode($temas);
