<?php
session_start();
include('adm/bd/db.php'); // Conexión a la base de datos

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $telefono = htmlspecialchars($_POST['telefono']);
    $nombre = htmlspecialchars($_POST['nombre']);

    // Validar si el teléfono comienza con "+56"
    if (strpos($telefono, '+56') !== 0) {
        $telefono = '+56' . $telefono;
    }

    // Validar que el número de teléfono tenga exactamente 9 dígitos después del prefijo
    $numero_sin_prefijo = substr($telefono, 3); // Quitar el "+56"
    if (!preg_match('/^\d{9}$/', $numero_sin_prefijo)) {
        die("El número de teléfono debe tener exactamente 9 dígitos después de +56.");
    }

    // Validar si el cliente ya existe
    $sql_cliente = "SELECT id FROM clientes WHERE telefono = ?";
    $stmt_cliente = $conn->prepare($sql_cliente);
    $stmt_cliente->bind_param("s", $telefono);
    $stmt_cliente->execute();
    $result_cliente = $stmt_cliente->get_result();

    if ($result_cliente->num_rows > 0) {
        // Cliente ya existe, obtener su ID
        $row = $result_cliente->fetch_assoc();
        $cliente_id = $row['id'];
    } else {
        // Registrar nuevo cliente
        $sql_insert = "INSERT INTO clientes (nombre, telefono) VALUES (?, ?)";
        $stmt_insert = $conn->prepare($sql_insert);
        $stmt_insert->bind_param("ss", $nombre, $telefono);
        if ($stmt_insert->execute()) {
            $cliente_id = $stmt_insert->insert_id;
        } else {
            die("Error al registrar cliente: " . $conn->error);
        }
    }

    // Crear nueva sesión para el cliente
    $_SESSION['cliente_id'] = $cliente_id;
    $_SESSION['nombre'] = $nombre;

    header('Location: pedidos.php'); // Redirigir al panel de pedidos
    exit();
}
?>

<html lang="es">
 <head>
  <meta charset="utf-8"/>
  <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
  <title>
   Selección MusicalVjJuancarlos
  </title>
  <script src="https://cdn.tailwindcss.com">
  </script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&amp;display=swap" rel="stylesheet"/>
  <style>
   body {
            font-family: 'Roboto', sans-serif;
            background-image: url('img/f6.jpeg');
            background-size: cover;
            background-position: center;
        }

        .form-container {
            background: rgba(255, 255, 255, 0.9);
            padding: 2rem;
            border-radius: 0.5rem;
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 91.666667%;
            max-width: 24rem;
            transform: scale(1);
            transition: all 0.5s ease-in-out;
        }

        .form-container:hover {
            transform: scale(1.05);
        }

        .form-container h2 {
            font-size: 1.5rem;
            font-weight: 700;
            color: #2563EB;
            margin-bottom: 1rem;
        }

        .form-container .input-group {
            margin-bottom: 1rem;
            position: relative;
        }

        .form-container input {
            width: 100%;
            padding: 0.5rem;
            border: 1px solid #D1D5DB;
            border-radius: 0.25rem;
            outline: none;
            transition: all 0.3s ease-in-out;
        }

        .form-container input:focus {
            box-shadow: 0 0 0 2px rgba(37, 99, 235, 0.5);
        }

        .form-container label {
            position: absolute;
            left: 0.75rem;
            top: 0.5rem;
            color: #6B7280;
            transition: all 0.3s ease-in-out;
            transform: translateY(-1.5rem) scale(0.75);
            transform-origin: top left;
            background-color: #FFFFFF;
            padding: 0 0.25rem;
            pointer-events: none;
        }

        .form-container button {
            width: 100%;
            padding: 0.5rem;
            background-color: #2563EB;
            color: #FFFFFF;
            font-weight: 700;
            border-radius: 0.25rem;
            outline: none;
            transition: all 0.3s ease-in-out;
        }

        .form-container button:hover {
            background-color: #1D4ED8;
        }

        .form-container button:focus {
            box-shadow: 0 0 0 2px rgba(37, 99, 235, 0.5);
        }
  </style>
 </head>
 <body class="flex flex-col items-center justify-center h-screen m-0">
  <div class="mb-4">
   <img alt="Logo of the company with a blue background and white text" class="w-72" height="100" src="img/logojc.png" width="300"/>
  </div>
  <div class="form-container">
   <h2>
    Iniciar Sesión
   </h2>
   <form action="" method="post">
    <div class="input-group">
     <input name="nombre" placeholder=" " required="" type="text"/>
     <label>
      👤 Nombre
     </label>
    </div>
    <div class="input-group">
     <input name="telefono" placeholder=" " required="" type="text"/>
     <label>
      ☏ Número de Teléfono (+56)
     </label>
    </div>
    <button type="submit">
     Ingresar
    </button>
   </form>
  </div>
 </body>
</html>