<?php
session_start();
include('bd/db.php');

$admin_actual = $_SESSION['admin'];

$sql = "
    SELECT * FROM chat 
    WHERE remitente = ? OR destinatario = ? 
    ORDER BY fecha_envio DESC 
    LIMIT 50";
$stmt = $conn->prepare($sql);
$stmt->bind_param('ss', $admin_actual, $admin_actual);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    echo "<div class='chat-message " . ($row['remitente'] === $admin_actual ? 'sent' : 'received') . "'>
        <strong>" . htmlspecialchars($row['remitente']) . ":</strong>
        <p>" . htmlspecialchars($row['mensaje']) . "</p>
        <div class='timestamp'>" . $row['fecha_envio'] . "</div>
    </div>";
}
?>
