<?php
include('bd/db.php'); // Conexión a la base de datos

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'])) {
    $id = intval($_POST['id']);

    // Consultar el pedido
    $sql_pedido = "SELECT cliente_id, tema FROM pedidos WHERE id = ?";
    $stmt_pedido = $conn->prepare($sql_pedido);
    $stmt_pedido->bind_param("i", $id);
    $stmt_pedido->execute();
    $result_pedido = $stmt_pedido->get_result();

    if ($result_pedido->num_rows > 0) {
        $pedido = $result_pedido->fetch_assoc();

        // Actualizar el estado del pedido
        $sql_update = "UPDATE pedidos SET estado = 'Tocado' WHERE id = ?";
        $stmt_update = $conn->prepare($sql_update);
        $stmt_update->bind_param("i", $id);
        $stmt_update->execute();

        // Enviar notificación push al cliente
        $cliente_id = $pedido['cliente_id'];
        $tema = $pedido['tema'];

        $sql_token = "SELECT token FROM clientes_tokens WHERE cliente_id = ?";
        $stmt_token = $conn->prepare($sql_token);
        $stmt_token->bind_param("i", $cliente_id);
        $stmt_token->execute();
        $result_token = $stmt_token->get_result();

        if ($result_token->num_rows > 0) {
            $token_row = $result_token->fetch_assoc();
            $token = $token_row['token'];

            // Enviar notificación con FCM
            $url = "https://fcm.googleapis.com/fcm/send";
            $headers = [
                'Authorization: key=BN7e_Z2XE8C3tP6j5kcsbc0V5_qwvSWerta5YpPGloM7Qpa9ib0na0L2Ni7C3M9NVC6QhuRhBKNe77hB7X7rA7s',
                'Content-Type: application/json'
            ];
            $data = [
                'to' => $token,
                'notification' => [
                    'title' => "Tema Tocado",
                    'body' => "Tu tema '$tema' ha sido marcado como tocado.",
                    'icon' => '/icono-notificacion.png'
                ]
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_exec($ch);
            curl_close($ch);
        }

        echo json_encode(['success' => true]);
        exit();
    }
}

echo json_encode(['success' => false]);
