<?php
include('bd/db.php'); // Conexión a la base de datos

// Verificar que el parámetro 'q' y 'categoria_id' estén definidos
if (isset($_GET['q']) && isset($_GET['categoria_id'])) {
    $q = htmlspecialchars($_GET['q']); // Texto del buscador
    $categoria_id = intval($_GET['categoria_id']); // Categoría seleccionada

    // Consulta SQL para buscar temas en la categoría seleccionada
    $sql_buscar = "SELECT tema, artista 
                   FROM musica 
                   WHERE categoria_id = ? 
                   AND (tema LIKE ? OR artista LIKE ?)";
    $stmt_buscar = $conn->prepare($sql_buscar);
    if (!$stmt_buscar) {
        die(json_encode(['error' => $conn->error])); // Manejo de errores
    }

    $like_query = "%$q%";
    $stmt_buscar->bind_param("iss", $categoria_id, $like_query, $like_query);
    $stmt_buscar->execute();
    $result_buscar = $stmt_buscar->get_result();

    // Formatear los resultados en JSON
    $resultados = [];
    while ($row = $result_buscar->fetch_assoc()) {
        $resultados[] = [
            'tema' => $row['tema'],
            'artista' => $row['artista']
        ];
    }

    // Devolver los resultados en formato JSON
    echo json_encode($resultados);
} else {
    echo json_encode(['error' => 'Parámetros inválidos']);
}
?>
