<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}

include('bd/db.php'); // Conexión a la base de datos
require '/home/fdaqfoui/vendor/autoload.php'; // Necesario para procesar archivos Excel con PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\IOFactory;

// Consultar categorías existentes
$sql_categorias = "SELECT id, nombre_categoria FROM categorias";
$result_categorias = $conn->query($sql_categorias);

// Procesar la carga de música
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $categoria_id = intval($_POST['categoria']);
    $archivo = $_FILES['archivo'];

    $ext = strtolower(pathinfo($archivo['name'], PATHINFO_EXTENSION)); // Obtener la extensión

    // Validar archivo por tipo
    if ($archivo['error'] === UPLOAD_ERR_OK && in_array($ext, ['txt', 'csv', 'xls', 'xlsx'])) {
        $ruta_temporal = $archivo['tmp_name'];
        $registros_exitosos = 0;
        $errores = 0;

        if ($ext === 'txt' || $ext === 'csv') {
            // Procesar TXT o CSV
            $contenido_archivo = file($ruta_temporal, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

            foreach ($contenido_archivo as $linea) {
                $partes = explode(',', $linea); // Separar por coma
                if (count($partes) === 2) {
                    $tema = trim($partes[0]);
                    $artista = trim($partes[1]);

                    // Insertar en la base de datos
                    $sql_insert = "INSERT INTO musica (categoria_id, tema, artista) VALUES (?, ?, ?)";
                    $stmt_insert = $conn->prepare($sql_insert);
                    $stmt_insert->bind_param("iss", $categoria_id, $tema, $artista);

                    if ($stmt_insert->execute()) {
                        $registros_exitosos++;
                    } else {
                        $errores++;
                    }
                } else {
                    $errores++;
                }
            }
        } elseif (in_array($ext, ['xls', 'xlsx'])) {
            // Procesar Excel
            $spreadsheet = IOFactory::load($ruta_temporal);
            $hoja = $spreadsheet->getActiveSheet();
            $filas = $hoja->toArray();

            foreach ($filas as $fila) {
                if (count($fila) >= 2) {
                    $tema = trim($fila[0]);
                    $artista = trim($fila[1]);

                    // Insertar en la base de datos
                    $sql_insert = "INSERT INTO musica (categoria_id, tema, artista) VALUES (?, ?, ?)";
                    $stmt_insert = $conn->prepare($sql_insert);
                    $stmt_insert->bind_param("iss", $categoria_id, $tema, $artista);

                    if ($stmt_insert->execute()) {
                        $registros_exitosos++;
                    } else {
                        $errores++;
                    }
                } else {
                    $errores++;
                }
            }
        }

        $mensaje = "Carga completa: $registros_exitosos registros exitosos, $errores errores.";
    } else {
        $mensaje = "Error: Archivo no válido o extensión incorrecta. Solo se aceptan archivos .txt, .csv, .xls, .xlsx.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cargar Música</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('img/fo1.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .content-container {
            flex: 1;
            margin: auto;
            width: 90%;
            max-width: 600px;
            background: rgba(255, 255, 255, 0.9);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        h2 {
            color: #0078D7;
            margin-bottom: 20px;
        }
        form {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 15px;
        }
        select, input[type="file"], button {
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ccc;
            font-size: 16px;
            width: 100%;
            max-width: 500px;
        }
        button {
            background-color: #0078D7;
            color: white;
            border: none;
            font-weight: bold;
            cursor: pointer;
        }
        button:hover {
            background-color: #005BB5;
        }
        .message {
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
        }
        .success {
            background-color: #DFF2BF;
            color: #4F8A10;
            border: 1px solid #4F8A10;
        }
        .error {
            background-color: #FFBABA;
            color: #D8000C;
            border: 1px solid #D8000C;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>

    <div class="content-container">
        <h2>Cargar Música</h2>
        <form action="" method="post" enctype="multipart/form-data">
            <!-- Selector de categorías -->
            <select name="categoria" required>
                <option value="" disabled selected>Seleccione una categoría</option>
                <?php while ($categoria = $result_categorias->fetch_assoc()): ?>
                    <option value="<?php echo $categoria['id']; ?>">
                        <?php echo $categoria['nombre_categoria']; ?>
                    </option>
                <?php endwhile; ?>
            </select>

            <!-- Campo para subir archivo -->
            <input type="file" name="archivo" accept=".txt,.csv,.xls,.xlsx" required>

            <!-- Botón para agregar -->
            <button type="submit">Procesar Archivo</button>
        </form>

        <!-- Mensaje de éxito o error -->
        <?php if (isset($mensaje)): ?>
            <div class="message <?php echo strpos($mensaje, 'Error') === false ? 'success' : 'error'; ?>">
                <?php echo $mensaje; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php include('pie.php'); ?>
</body>
</html>
