<?php
session_start();
if (!isset($_SESSION['admin'])) {
    echo json_encode(['success' => false, 'message' => 'No autorizado']);
    exit();
}

include('bd/db.php'); // Conexión a la base de datos

// Validar entrada
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pedido_id = intval($_POST['id'] ?? 0);
    $mensaje = trim($_POST['mensaje'] ?? '');

    if ($pedido_id === 0 || empty($mensaje)) {
        echo json_encode(['success' => false, 'message' => 'Datos incompletos']);
        exit();
    }

    // Actualizar estado del mensaje
    $sql = "UPDATE pedidos SET estado = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Error al preparar la consulta']);
        exit();
    }

    $stmt->bind_param("si", $mensaje, $pedido_id);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Mensaje enviado correctamente']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al enviar el mensaje']);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
}
?>
