<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}

include('bd/db.php'); // Conexión a la base de datos
require_once '/home/fdaqfoui/vendor/autoload.php'; // Asegúrate de tener PhpSpreadsheet instalado

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Guardar clientes activos con su historial en la tabla sesiones y exportar a Excel
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['guardar_sesion'])) {
    $nombre_sesion = htmlspecialchars($_POST['nombre_sesion']);

    if (!empty($nombre_sesion)) {
        // Consultar todos los clientes y su historial de canciones
        $sql_clientes_historial = "
            SELECT c.id, c.nombre, c.telefono, 
                   GROUP_CONCAT(CONCAT(IFNULL(m.tema, '(Pedido Especial)'), ' - ', p.estado) SEPARATOR '; ') AS historial
            FROM clientes c
            LEFT JOIN pedidos p ON c.id = p.cliente_id
            LEFT JOIN musica m ON p.tema = m.tema
            GROUP BY c.id";
        $result_clientes_historial = $conn->query($sql_clientes_historial);

        if ($result_clientes_historial->num_rows > 0) {
            $clientes_guardados = [];
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Configurar encabezados en el archivo Excel
            $sheet->setCellValue('A1', 'ID');
            $sheet->setCellValue('B1', 'Nombre');
            $sheet->setCellValue('C1', 'Teléfono');
            $sheet->setCellValue('D1', 'Historial de Canciones');
            $rowIndex = 2;

            while ($row = $result_clientes_historial->fetch_assoc()) {
                $clientes_guardados[] = $row;

                // Guardar o actualizar cliente en la tabla `clientes_totales`
                $sql_totales = "
                    INSERT INTO clientes_totales (id, nombre, telefono, historial_canciones)
                    VALUES (?, ?, ?, ?)
                    ON DUPLICATE KEY UPDATE
                    nombre = VALUES(nombre), telefono = VALUES(telefono), historial_canciones = VALUES(historial_canciones)";
                $stmt_totales = $conn->prepare($sql_totales);
                $stmt_totales->bind_param("isss", $row['id'], $row['nombre'], $row['telefono'], $row['historial']);
                $stmt_totales->execute();

                // Agregar datos al archivo Excel
                $sheet->setCellValue("A$rowIndex", $row['id']);
                $sheet->setCellValue("B$rowIndex", $row['nombre']);
                $sheet->setCellValue("C$rowIndex", $row['telefono']);
                $sheet->setCellValue("D$rowIndex", $row['historial']);
                $rowIndex++;
            }

            // Convertir clientes guardados a JSON
            $clientes_guardados_json = json_encode($clientes_guardados);

            // Guardar en la tabla sesiones
            $sql_guardar_sesion = "INSERT INTO sesiones (nombre_sesion, clientes_guardados) VALUES (?, ?)";
            $stmt_guardar_sesion = $conn->prepare($sql_guardar_sesion);
            $stmt_guardar_sesion->bind_param("ss", $nombre_sesion, $clientes_guardados_json);

            if ($stmt_guardar_sesion->execute()) {
                // Guardar archivo Excel
                $ruta_excel = "sesiones/{$nombre_sesion}.xlsx";
                $writer = new Xlsx($spreadsheet);
                $writer->save($ruta_excel);

                // Limpiar la tabla de clientes y pedidos
                $sql_limpiar_clientes = "DELETE FROM clientes";
                $sql_limpiar_pedidos = "DELETE FROM pedidos";
                $conn->query($sql_limpiar_clientes);
                $conn->query($sql_limpiar_pedidos);

                $mensaje = "Clientes y su historial guardados como '$nombre_sesion', exportados a Excel, registrados en `clientes_totales` y eliminados correctamente.";
            } else {
                $mensaje = "Error al guardar la sesión.";
            }
        } else {
            $mensaje = "No hay clientes activos para guardar.";
        }
    } else {
        $mensaje = "El nombre de la sesión no puede estar vacío.";
    }
}

// Consultar clientes
$sql_clientes = "SELECT id, nombre, telefono FROM clientes ORDER BY id ASC";
$result_clientes = $conn->query($sql_clientes);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Clientes</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('img/fo1.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            color: #333;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .content-container {
            flex: 1;
            margin: auto;
            width: 90%;
            max-width: 1100px;
            padding: 20px;
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.9);
            text-align: center;
        }
        h2 {
            color: #0078D7;
        }
        .guardar-sesion {
            margin-bottom: 20px;
        }
        .guardar-sesion input, .guardar-sesion button {
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        button {
            background-color: #0078D7;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
        }
        button:hover {
            background-color: #005BB5;
        }
        table {
            width: 100%;
            margin: 0 auto;
            border-collapse: collapse;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        th, td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #0078D7;
            color: white;
        }
        .message {
            background-color: #DFF2BF;
            color: #4F8A10;
            padding: 10px;
            border: 1px solid #4F8A10;
            border-radius: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>

    <div class="content-container">
        <h2>Lista de Clientes</h2>

        <?php if (isset($mensaje)): ?>
            <div class="message"><?php echo $mensaje; ?></div>
        <?php endif; ?>

        <!-- Formulario para guardar clientes -->
        <form class="guardar-sesion" action="" method="post">
            <input type="text" name="nombre_sesion" placeholder="Nombre de la sesión" required>
            <button type="submit" name="guardar_sesion">Guardar Clientes</button>
        </form>

        <table>
            <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Teléfono</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result_clientes->num_rows > 0): ?>
                    <?php while ($row = $result_clientes->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['nombre']); ?></td>
                            <td><?php echo htmlspecialchars($row['telefono']); ?></td>
                            <td>
                                <form method="post" action="" style="display: inline;">
                                    <input type="hidden" name="eliminar_id" value="<?php echo $row['id']; ?>">
                                    <button type="submit" class="eliminar">Eliminar</button>
                                </form>
                                <form method="get" action="editar_cliente.php" style="display: inline;">
                                    <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                    <button type="submit">Editar</button>
                                </form>
                                
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3">No hay clientes registrados.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <script>
        function enviarMensaje(telefono) {
            alert(`Enviando mensaje al número: ${telefono}`);
            // Aquí puedes implementar la lógica para enviar un mensaje (API de mensajería).
        }
    </script>

    <?php include('pie.php'); ?>
</body>
</html>
