<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pedidos Musicales</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('img/fo1.jpeg');
            background-size: cover;
            background-position: center;
            color: #333;
        }
        .content-container {
            margin: auto;
            width: 90%;
            max-width: 1100px;
            padding: 20px;
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.9);
            text-align: center;
            margin-top: 20px;
        }
        h2 {
            color: #0078D7;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #0078D7;
            color: white;
        }
        button {
            padding: 10px;
            border-radius: 5px;
            cursor: pointer;
            border: none;
            margin-right: 5px;
        }
        button.tocado {
            background: gray;
            color: white;
        }
        button.tocado:hover {
            background: darkgray;
        }
        button.aceptado {
            background: blue;
            color: white;
        }
        button.aceptado:hover {
            background: darkblue;
        }
        button.no-se-toca {
            background: orange;
            color: white;
        }
        button.no-se-toca:hover {
            background: darkorange;
        }
        button.eliminar {
            background: red;
            color: white;
        }
        button.eliminar:hover {
            background: darkred;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>
    <div class="content-container">
        <h2>Pedidos Musicales</h2>
        <table>
            <thead>
                <tr>
                    <th>Tema</th>
                    <th>Cliente</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="pedidos-container">
                <!-- Los pedidos se cargarán dinámicamente -->
            </tbody>
        </table>
    </div>
    <?php include('pie.php'); ?>

    <script>
        const pedidosContainer = document.getElementById('pedidos-container');
        let pedidosAnteriores = [];
        let tituloOriginal = document.title;
        let contadorNotificaciones = 0;

        // Función para cargar pedidos y actualizar el número de notificaciones
        async function cargarPedidos() {
            try {
                const response = await fetch('cargar_pedidos.php');
                const data = await response.json();
                pedidosContainer.innerHTML = '';

                // Actualizar la tabla de pedidos
                data.pedidos.forEach(pedido => {
                    const tr = document.createElement('tr');
                    tr.innerHTML = `
                        <td>${pedido.tema_mostrado}</td>
                        <td>${pedido.cliente}</td>
                        <td>${pedido.estado}</td>
                        <td>
                            <button class="aceptado" onclick="cambiarEstado(${pedido.id}, 'Aceptado')">Aceptar</button>
                            <button class="tocado" onclick="cambiarEstado(${pedido.id}, 'Tocado')">Tocado</button>
                            <button class="no-se-toca" onclick="cambiarEstado(${pedido.id}, 'No se toca')">No se toca</button>
                            <button class="eliminar" onclick="eliminarPedido(${pedido.id})">Eliminar</button>
                        </td>
                    `;
                    pedidosContainer.appendChild(tr);
                });

                // Comparar el número de pedidos para determinar cambios
                if (pedidosAnteriores.length !== data.pedidos.length) {
                    contadorNotificaciones++;
                    document.title = `(${contadorNotificaciones}) Pedidos Musicales`;
                }

                // Actualizar el historial de pedidos
                pedidosAnteriores = data.pedidos;

            } catch (error) {
                console.error("Error al cargar los pedidos:", error);
            }
        }

        // Función para cambiar el estado de un pedido
        async function cambiarEstado(id, estado) {
            try {
                const response = await fetch('cambiar_estado.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: `id=${id}&estado=${encodeURIComponent(estado)}`
                });
                const data = await response.json();

                if (data.success) {
                    cargarPedidos(); // Recargar la lista de pedidos
                } else {
                    console.error(data.message);
                }
            } catch (error) {
                console.error(`Error al cambiar el estado a ${estado}:`, error);
            }
        }

        // Función para eliminar un pedido
        async function eliminarPedido(id) {
            try {
                await fetch('eliminar_pedido.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: `id=${id}`
                });
                cargarPedidos(); // Recargar la lista de pedidos
            } catch (error) {
                console.error("Error al eliminar el pedido:", error);
            }
        }

        // Resetear el contador de notificaciones al enfocar la ventana
        window.addEventListener('focus', () => {
            document.title = tituloOriginal;
            contadorNotificaciones = 0;
        });

        // Cargar pedidos al inicio y cada 5 segundos
        cargarPedidos();
        setInterval(cargarPedidos, 5000);
    </script>
</body>
</html>
