<?php
include('adm/bd/db.php'); // Conexión a la base de datos

if (!isset($_GET['cliente_id'])) {
    echo json_encode(['error' => 'Cliente ID no proporcionado.']);
    exit();
}

$cliente_id = intval($_GET['cliente_id']);

// Consultar el estado más reciente del pedido del cliente
$sql_estado_pedido = "
    SELECT p.estado 
    FROM pedidos p
    WHERE p.cliente_id = ?
    ORDER BY p.fecha_hora DESC
    LIMIT 1";
$stmt_estado_pedido = $conn->prepare($sql_estado_pedido);
$stmt_estado_pedido->bind_param("i", $cliente_id);
$stmt_estado_pedido->execute();
$result_estado_pedido = $stmt_estado_pedido->get_result();

if ($result_estado_pedido->num_rows > 0) {
    $row = $result_estado_pedido->fetch_assoc();
    echo json_encode(['estado' => $row['estado']]);
} else {
    echo json_encode(['estado' => 'No hay pedidos registrados.']);
}
?>

