<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}

include('bd/db.php'); // Conexión a la base de datos

// Consultar los últimos 5 temas solicitados
$sql_ultimos_pedidos = "
    SELECT 
        IF(m.tema IS NOT NULL, m.tema, CONCAT('<strong style=\"color: red;\">(Canción no encontrada)</strong> ', p.detalles)) AS tema_mostrado,
        p.estado,
        c.nombre AS cliente
    FROM pedidos p
    LEFT JOIN musica m ON p.tema = m.tema
    JOIN clientes c ON p.cliente_id = c.id 
    ORDER BY p.id DESC LIMIT 5";
$result_ultimos_pedidos = $conn->query($sql_ultimos_pedidos);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio - Administrador</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('img/fo1.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            color: #333;
        }
        .content-container {
            flex: 1;
            margin: auto;
            width: 90%;
            max-width: 1100px;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        h2 {
            color: #fff;
            margin-bottom: 20px;
        }
        table {
            width: 90%;
            margin: 0 auto;
            border-collapse: collapse;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
            color: #333;
        }
        th {
            background-color: #0078D7;
            color: white;
        }
        .estado-pendiente {
            color: green;
            font-weight: bold;
        }
        .estado-tocado {
            color: red;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>

    <div class="content-container">
        <h2>Últimos 5 Temas Solicitados</h2>
        <table>
            <thead>
                <tr>
                    <th>Tema</th>
                    <th>Cliente</th>
                    <th>Estado</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result_ultimos_pedidos->num_rows > 0): ?>
                    <?php while ($row = $result_ultimos_pedidos->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['tema_mostrado']; ?></td>
                            <td><?php echo $row['cliente']; ?></td>
                            <td class="<?php echo $row['estado'] == 'Tocado' ? 'estado-tocado' : 'estado-pendiente'; ?>">
                                <?php echo $row['estado'] == 'Tocado' ? 'Reproducida' : 'En Espera'; ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="3">No hay pedidos recientes.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php include('pie.php'); ?>
</body>
</html>
