<?php
session_start();
include('bd/db.php'); // Conexión a la base de datos

if (!isset($_SESSION['cliente_id'])) {
    header('Location: index.php'); // Redirigir si no hay cliente registrado
    exit();
}

$cliente_id = $_SESSION['cliente_id'];

// Consultar los pedidos del cliente actual
$sql_mis_pedidos = "SELECT tema, estado, 
                           FIND_IN_SET(id, (SELECT GROUP_CONCAT(id ORDER BY id) FROM pedidos WHERE estado = 'Pendiente')) AS posicion
                    FROM pedidos WHERE cliente_id = ? ORDER BY id";
$stmt_mis_pedidos = $conn->prepare($sql_mis_pedidos);
$stmt_mis_pedidos->bind_param("i", $cliente_id);
$stmt_mis_pedidos->execute();
$result_mis_pedidos = $stmt_mis_pedidos->get_result();

// Consultar los pedidos de otros clientes
$sql_otros_pedidos = "SELECT c.nombre, p.tema, p.estado FROM pedidos p 
                      JOIN clientes c ON p.cliente_id = c.id
                      WHERE p.cliente_id != ? ORDER BY p.id";
$stmt_otros_pedidos = $conn->prepare($sql_otros_pedidos);
$stmt_otros_pedidos->bind_param("i", $cliente_id);
$stmt_otros_pedidos->execute();
$result_otros_pedidos = $stmt_otros_pedidos->get_result();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estado - Sistema de Pedidos Musicales</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('img/fondo.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            color: #333;
        }
        .logo-container {
            text-align: center;
            margin-top: 250px;
        }
        .logo-container img {
            width: 200px;
        }
        .content-container {
            margin: 20px auto;
            text-align: center;
            width: 80%;
        }
        .status-container, .list-container {
            background: rgba(255, 255, 255, 0.9);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            text-align: left;
        }
        h2, h3 {
            color: #0078D7;
        }
        ul {
            list-style: none;
            padding: 0;
        }
        ul li {
            padding: 10px;
            border-bottom: 1px solid #ddd;
        }
        ul li:last-child {
            border-bottom: none;
        }
        ul li span {
            font-weight: bold;
            color: #0078D7;
        }
        .btn-container {
            text-align: center;
        }
        .btn-container button {
            background-color: #0078D7;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
            font-size: 16px;
        }
        .btn-container button:hover {
            background-color: #005BB5;
        }
    </style>
</head>
<body>
    <div class="logo-container">
        <img src="img/logo.png" alt="Logo">
    </div>

    <div class="content-container">
        <!-- Mis pedidos -->
        <div class="status-container">
            <h2>Tus Pedidos</h2>
            <?php if ($result_mis_pedidos->num_rows > 0): ?>
                <ul>
                    <?php while ($row = $result_mis_pedidos->fetch_assoc()): ?>
                        <li>
                            <span><?php echo $row['tema']; ?></span> - 
                            Posición: <?php echo $row['posicion'] ?? 'N/A'; ?> - 
                            Estado: <?php echo $row['estado']; ?>
                        </li>
                    <?php endwhile; ?>
                </ul>
            <?php else: ?>
                <p>No has realizado ningún pedido.</p>
            <?php endif; ?>
        </div>

        <!-- Pedidos de otros usuarios -->
        <div class="list-container">
            <h3>Pedidos de Otros Usuarios</h3>
            <?php if ($result_otros_pedidos->num_rows > 0): ?>
                <ul>
                    <?php while ($row = $result_otros_pedidos->fetch_assoc()): ?>
                        <li>
                            <span><?php echo $row['nombre']; ?>:</span> 
                            <?php echo $row['tema']; ?> - 
                            Estado: <?php echo $row['estado']; ?>
                        </li>
                    <?php endwhile; ?>
                </ul>
            <?php else: ?>
                <p>No hay pedidos de otros usuarios.</p>
            <?php endif; ?>
        </div>

        <!-- Botón para hacer otro pedido -->
        <div class="btn-container">
            <button onclick="window.location.href='pedidos.php'">Solicitar otro tema</button>
        </div>
    </div>
</body>
</html>
