<?php
include('adm/bd/db.php');

// Obtener el juego más reciente activo desde la base de datos
$sql_juego = "SELECT * FROM juegos ORDER BY fecha_generada DESC LIMIT 1";
$result_juego = $conn->query($sql_juego);

if ($result_juego->num_rows > 0) {
    $juego = $result_juego->fetch_assoc();
    $palabras = json_decode($juego['juego_config'], true)['palabras']; // Extraer palabras de la configuración
} else {
    $palabras = []; // No hay juego configurado
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ruleta</title>
    <style>
        :root {
            --tamano: 500px;
            --grados: calc(360deg / <?php echo count($palabras); ?>);
            --rotacion: 0deg;
            --color-impar: turquoise;
            --color-par: yellow;
            --color-borde: #000;
            --color-flecha: black;
        }

        body {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }

        #triangulo {
            position: absolute;
            width: 0;
            height: 0;
            border-left: 25px solid transparent;
            border-right: 25px solid transparent;
            border-bottom: 50px solid var(--color-flecha);
            transform: translateY(-50px);
        }

        #ruleta {
            position: relative;
            width: var(--tamano);
            height: var(--tamano);
            background-color: red;
            border-radius: 50%;
            border: 10px solid var(--color-borde);
            will-change: transform;
            transition: transform 4s cubic-bezier(0, 0, 0.3, 1);
            transform: rotate(var(--rotacion));
        }

        #sectores {
            position: absolute;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            overflow: hidden;
        }

        #sectores div {
            position: absolute;
            top: 0;
            left: 50%;
            width: 50%;
            height: 50%;
            transform-origin: 0% 100%;
            transform: rotate(calc(var(--grados) * var(--posicion))) skewY(calc((90deg - var(--grados)) * -1));
        }

        #sectores div:nth-child(odd) {
            background-color: var(--color-impar);
        }

        #sectores div:nth-child(even) {
            background-color: var(--color-par);
        }

        #sectores div span {
            display: block;
            position: absolute;
            top: 50%;
            left: 0;
            width: 100%;
            transform: rotate(calc(var(--grados) / -2));
            transform-origin: 50% 100%;
            text-align: center;
            font-size: 16px;
            color: black;
            font-weight: bold;
        }

        button {
            margin-top: 20px;
            padding: 10px 20px;
            font-size: 18px;
            background-color: #0078D7;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        button:hover {
            background-color: #005BB5;
        }

        .resultado {
            margin-top: 20px;
            font-size: 24px;
            color: #333;
        }
    </style>
</head>
<body>
    <?php if (!empty($palabras)): ?>
        <div id="triangulo"></div>
        <div id="ruleta">
            <div id="sectores">
                <?php foreach ($palabras as $i => $palabra): ?>
                    <div style="--posicion: <?php echo $i; ?>;">
                        <span><?php echo htmlspecialchars($palabra); ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <button id="jugar">Girar</button>
        <div class="resultado" id="resultado"></div>
    <?php else: ?>
        <div class="no-juego">
            <h2>No hay un juego activo en este momento.</h2>
        </div>
    <?php endif; ?>

    <script>
        const ruleta = document.getElementById('ruleta');
        const resultado = document.getElementById('resultado');
        const palabras = <?php echo json_encode($palabras); ?>;
        const gradosPorSector = 360 / palabras.length;

        document.getElementById('jugar')?.addEventListener('click', () => {
            const randomIndex = Math.floor(Math.random() * palabras.length);
            const rotacion = 360 * 3 + (360 - randomIndex * gradosPorSector) - gradosPorSector / 2;

            ruleta.style.setProperty('--rotacion', `${rotacion}deg`);

            setTimeout(() => {
                resultado.textContent = `¡Resultado: ${palabras[randomIndex]}!`;
            }, 4000); // Mostrar resultado tras 4s, que es la duración de la animación
        });
    </script>
</body>
</html>
