<?php
/**
* @package t2gicons
* @author Themes2Go
* @textdomain t2gicons
*/
?>

<h4><?php echo esc_attr__("Quick manual") ?></h4>
<div class="t2gicons-card">
	<div class="t2gicons-optimalreading">						
		
		<div class="t2gicons-section">
			<h5 class="t2gicons-form-section-title"><span><?php echo esc_attr__("Important", "t2gicons"); ?></span></h5>
			<p>You cannot use an icon set before the activation. You don't need to activate icons singularly in order to use them; you only need to activate its icon set.</p>
			<p class="t2gicons-important"><span class="red-text">Notice:</span> the more sets you activate, the slower your site will be. Activate only the icon sets you need.</p>
		</div>
		<div class="t2gicons-section">
			<h5 class="t2gicons-form-section-title"><span><?php echo esc_attr__("How to activate icon sets", "t2gicons"); ?></span></h5>
			<p>In the settings page you can <strong>preview inactive sets</strong> to see what they contains <strong>without the need to activate the set</strong> by clicking the button <a href="#" class="btn blue-grey lighten-3">PREVIEW</a>. </p>
			<p>To make an icon set available for usage, click the <a href="#!" class="btn btn-primary button-large  light-green darken-1">Activate</a> button.
			</p>
			<p class="t2gicons-important"><span class="red-text">Notice:</span> If you deactivate a set that is being used in some page, the icons will appear empty for your visitors. The settings page has no way to know if you used a certain icon in your pages.</p>
		</div>
		<div class="t2gicons-section">
			<h5 class="t2gicons-form-section-title"><span><?php echo esc_attr__("Icons bookmarking", "t2gicons"); ?></span></h5>
			<p>Icons bookmarking in the settings page <strong>is only a visual help</strong> for your icon settings. In the settings page, you can click on any icon to "bookmark" it. When you bookmark an icon, on the sets list a star 
			(<span class="dashicons dashicons-star-filled amber-text"></span>) will appear for the font set where that icon belongs.</p>
			<p class="t2gicons-important"><span class="red-text">Notice:</span> Bookmarking doesn't affect activation and only works as visual cue to know which icons you like and which sets they belong to.</p>
			<h5>Bookmarking inactive icons</h5>
			<p>If you bookmark any icon belonging to an inactive set, in the sets list a warning (<span class="dashicons dashicons-warning deep-orange-text"></span>) will appear, to remember that you want to use an icon from an inactive set. You can click on the set name to scroll until the activation button, and activate your set.</p>
			<p>Upon set activation/deactivation or page reload, the bookmarks will be removed.</p>
		</div>
		<div class="t2gicons-section">
			<h5 class="t2gicons-form-section-title"><span><?php echo esc_attr__("Adding icons to your pages", "t2gicons"); ?></span></h5>
			<ol>
				<li>In the settings page, activate the icon set you need</li>
				<li>When you edit a page, click on the button "Icons2Go"</li>
				<li>A modal window will appear, you can choose icon set, icon, shape and color</li>
				<li>Click "Add" and the shortcode will appear in the contents</li>
			</ol>
		</div>
		<div class="t2gicons-section">
			<h5 class="t2gicons-form-section-title"><span><?php echo esc_attr__("Adding icons with Visual Composer", "t2gicons"); ?></span></h5>
			<ol>
				<li>Click the (+) to add a Visual Composer element</li>
				<li>Click on the button "Icons2Go"</li>
				<li>A modal window will appear, you can choose icon set, icon, shape and color</li>
				<li>Click "Add" and the element will appear in the contents</li>
			</ol>
		</div>
	</div>
</div>