<?php 
/**
 * @package Pro.Radio Dedications
 * 
 * Admin Settings
 * 
 * */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! function_exists( 'prdedications_settings_page_menu' ) ) {
	add_action( 'admin_menu', 'prdedications_settings_page_menu' );
	function prdedications_settings_page_menu() {
		add_submenu_page(
		    'edit.php?post_type=prdedicationslist',
		   	esc_html__( 'Settings', 'proradio-dedications' ),
			esc_html__( 'Settings', 'proradio-dedications' ),
		    'manage_options',
		    'prdedications_settings',
		    'prdedications_settings_page'
		);

		


	    add_submenu_page(
		    'edit.php?post_type=prdedicationslist',
		   	esc_html__( 'Documentation', 'proradio-dedications' ),
			esc_html__( 'Documentation', 'proradio-dedications' ),
		    'manage_options',
		    'prdedications_documentation', 
		    'prdedications_documentation'
		);

	}	
}







if(!function_exists('prdedications_settings_page')){

	function prdedications_settings_page() {

		/**
		 *  We check if the use is qualified enough
		 */
		$user = wp_get_current_user();
		$allowed_roles = array( 'administrator' );
		if (!current_user_can('manage_options') || !array_intersect($allowed_roles, $user->roles ) )  {
			wp_die( esc_html__('You do not have sufficient permissions to access this page.' , 'proradio-dedications') );
		}

		if( function_exists('proradio_whmcs_check_service')){
			$service = proradio_whmcs_check_service( PRDEDICATIONS_SERVICE_NAME );
		} else {
			wp_die('The Pro Radio Dedications Plugin can only be used with Pro Radio WordPress Theme');
		}

		include('controls.php');




		/**
		 * =====================================================
		 * Form ouput
		 * =====================================================
		 * */
		if(function_exists('prdedications_form_generator')){
			$nonce_action = 'prdedications_settings_save';
			$nonce_name = 'prdedications_settings_nonce';
			$title = esc_html__("Global settings", "proradio-dedications");
			?>
				<div class="prdedications prdedications_settings-framework prdedications_settings-optionspage">
					<?php include 'header.php'; ?>

					<?php
					/**
					 * =====================================================
					 * Promo header
					 * =====================================================
					 * */
					if( $service ){
						require_once ('header-date.php');
					} else {
						require_once ('promo.php');
					}
					?>

					<?php
					
					
					
					/**
					 * =====================================================
					 * Form
					 * =====================================================
					 * */
					prdedications_form_generator( $title, $controls, $nonce_action , $nonce_name); 

					?>
				</div>
			<?php 
		}
		return;	
	}
}




if(!function_exists('prdedications_documentation')){
	function prdedications_documentation() {
		$title = esc_html__("Plugin documentation", "proradio-dedications");
		?>
			<div class="prdedications prdedications_settings-framework prdedications_settings-optionspage">
				<?php include 'header.php'; ?>
				<p><?php esc_html_e('The plugin documentation is available online at the following link:','proradio-dedications'); ?></p>
				<p><a href="https://pro.radio/shop/knowledgebase/58/Pro-Radio-Dedications" target="_blank"><?php esc_html_e('https://pro.radio/shop/knowledgebase/58/Pro-Radio-Dedications','proradio-dedications'); ?></a></p>
				
			</div>
		<?php 
		return;	
	}
}
/**
 * =====================================================
 * End of file
 * =====================================================
 * */




