<?php
/**
 * @package WordPress
 * @subpackage proradio-dedications
 * @version 1.0.0
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if(!function_exists('prdedications_dedication_register_type')){
    add_action('init', 'prdedications_dedication_register_type');  
    function prdedications_dedication_register_type() {
        $labels = array(
            'name'                  => esc_html__("Dedication list","pdws"),
            'singular_name'         => esc_html__("Dedication","pdws"),
            'add_new'               => esc_html__("Add new dedication","pdws"),
            'add_new_item'          => esc_html__("Add new dedication","pdws"),
            'edit_item'             => esc_html__("Edit dedication","pdws"),
            'new_item'              => esc_html__("New dedication","pdws"),
            'all_items'             => esc_html__("All dedications","pdws"),
            'view_item'             => esc_html__("View dedication","pdws"),
            'search_items'          => esc_html__("Search dedications","pdws"),
            'not_found'             => esc_html__("No dedications found","pdws"),
            'not_found_in_trash'    => esc_html__("No dedications found in trash","pdws"),
            'menu_name'             => esc_html__("Dedication list","pdws")
        );
        $args = array(
            'labels'                    => $labels,
            'public'                    => false,
            'publicly_queryable'        => false,
            'show_ui'                   => true, 
            'show_in_menu'              => true, 
            'query_var'                 => true,
            'rewrite'                   => false,
            'capability_type'           => 'page',
            'has_archive'               => true,
            'hierarchical'              => false,
            'menu_position'             => 55,
            'page-attributes'           => true,
            'show_in_nav_menus'         => true,
            'show_in_admin_bar'         => true,
            'show_in_menu'              => true,
            'menu_icon'                => 'dashicons-heart',
            'supports'                  => array('title','editor' ),
            'show_in_rest'              => false,
        ); 
        if(function_exists('register_post_type')){
            register_post_type( "prdedicationslist" , $args );
        }

        $custom = array(
            array(
                'label' => esc_html__( 'Name', "proradio" ),
                'id'    => 'prdedication_name',
                'type'  => 'text'
            ),
            array(
                'label' => esc_html__( 'Email', "proradio" ),
                'id'    => 'prdedication_email',
                'type'  => 'text'
            ),
            array(
                'label' => esc_html__( 'Phone', "proradio" ),
                'id'    => 'prdedication_phone',
                'type'  => 'text'
            ),
            array(
                'label' => esc_html__( 'Privacy', "proradio" ),
                'id'    => 'prdedication_privacy',
                'type'  => 'text'
            ),
           
            array(
                'label' => esc_html__( 'Song', "proradio" ),
                'id'    => 'prdedication_song',
                'type'  => 'text'
            ),
            array(
                'label' => esc_html__( 'Artwork link', "proradio" ),
                'id'    => 'prdedication_art',
                'type'  => 'text'
            ),
            array(
                'label' => esc_html__( 'Link', "proradio" ),
                'id'    => 'prdedication_link',
                'type'  => 'text'
            ),
             array(
                'label' => esc_html__( 'IP', "proradio" ),
                'id'    => 'prdedication_ip',
                'type'  => 'text'
            ),
             array(
                'label' => esc_html__( 'Email notification sent', "proradio" ),
                'id'    => 'prdedication_notif',
                'type'  => 'editor'
            ),
        );


        if (class_exists('Custom_Add_Meta_Box')){
            $custom = new Custom_Add_Meta_Box( 'dedication_customtab', esc_html__('Details', "proradio"), $custom, 'prdedicationslist', true );
        }
    }
}

