<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorDedicationsScroll extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-dedications-scroll'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Dedications scroller', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-radio-feed';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}

	// Javascript
		/**
	 * @since version PR.2.3.0 loaded from minified scripts.
	 * To unse unminified, edit _plugin.php line 53 $use_minified_script = true;
	 * 
	 * 
	 * */
	 public function __construct($data = [], $args = null) {
      parent::__construct($data, $args);
      wp_register_script( 'proradio-elementor-dedications-scroll', plugins_url( '/dedications.js', __FILE__ ), [ 'elementor-frontend' ], '1.0.0', true );
   	}
 	public function get_script_depends() {
	     return [ 'proradio-elementor-dedications-scroll' ];
	}


	protected function register_controls() {
		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__( 'Settings', 'proradio-elementor' ),
			]
		);	

			$this->add_control(
				'items_per_page',
				[
					'label' => esc_html__( "Number of items", "proradio-elementor" ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 0,
					'max' => 20,
					'step' => 1,
					'default' => 3,
				]
			);

			

			$this->add_control(
				'duration',
				[
					'label' => esc_html__( 'Animation duration', 'textdomain' ),
					'description' => esc_html__( '1-10 where 10 = slowest', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 10,
					'step' => 1,
					'default' => 6,
				]
			);

			$this->add_control(
				'textlabel',
				[
					'label' => esc_html__( "label text", "proradio-elementor" ),
					'type' => Controls_Manager::TEXT,
					'default' => 'Dedications'
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'proradio-txt-typo',
					'label' => __( 'Typography','proradio-elementor'),
					'scheme' => Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .proradio-dedications-scroller span, {{WRAPPER}} .proradio-dedications-scroller .proradio-dedications-scroller__label, {{WRAPPER}} .proradio-dedications-scroller a'
				]
			);

			$this->add_control(
				'proradio-label-background',
				[
					'label' => esc_html__( 'Label background', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-scroller' => '--proradio-colors-accent: {{VALUE}}',
					]
				]
			);
			$this->add_control(
				'proradio-label-txt',
				[
					'label' => esc_html__( 'Label text', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-scroller' => '--proradio-colors-accent-text: {{VALUE}}',
					]
				]
			);

			$this->add_control(
				'proradio-name-background',
				[
					'label' => esc_html__( 'Name background', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-scroller' => '--proradio-colors-primary-light: {{VALUE}}',
					]
				]
			);
			$this->add_control(
				'proradio-name-txt',
				[
					'label' => esc_html__( 'Name text', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-scroller' => '--proradio-colors-primary-text: {{VALUE}}',
					]
				]
			);
			$this->add_control(
				'proradio-txt',
				[
					'label' => esc_html__( 'Text color', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-scroller' => 'color: {{VALUE}} !important;',
					]
				]
			);
		$this->end_controls_section();
	}

	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		if(function_exists('proradio_dedications_scroll')){
			echo proradio_dedications_scroll( $atts );
		}
	}
	
	protected function content_template() {}
}