<?php
/**
 * @package proradio-megafooter
 */

/**
 * [function proradio_megafooter_override_template_path]
 * Override path:
 * to override any template, place it in the theme into a subfolder called 
 * as the output of this function
 */
if (!function_exists('proradio_megafooter_local_template_path')){
function proradio_megafooter_local_template_path() {
	return proradio_megafooter_plugin_dir_path().'templates/';
}}

/**
 * [function proradio_megafooter_override_template_path]
 * Override path:
 * to override any template, place it in the theme into a subfolder called 
 * as the output of this function
 */
if (!function_exists('proradio_megafooter_override_template_path')){
function proradio_megafooter_override_template_path() {
	return 'proradio-megafooter-templates/';
}}

/**
 * Load Elementor styles on all pages in the head to avoid CSS files being loaded in the footer
 */
if(!function_exists('proradio_elementor_css_in_head')){
	add_action( 'wp_enqueue_scripts', 'proradio_elementor_css_in_head' );
	function proradio_elementor_css_in_head(){
		if( !function_exists('proradio_megafooter_posttype_name')){
			return;
		}
		$args = array(
			'post_type' 			=>  proradio_megafooter_posttype_name(),
			'posts_per_page' 		=> -1,
			'post_status' 			=> 'publish',
			'paged' 				=> 1,
			'suppress_filters' 		=> false,
			'ignore_sticky_posts' 	=> 1,
			'orderby' 				=> array( 'orderby' => array( 'menu_order' => 'ASC' ) )
		);
		$elementor_wp_query = new WP_Query( $args );
		if ( $elementor_wp_query->have_posts() ) { 
			while ( $elementor_wp_query->have_posts() ) : $elementor_wp_query->the_post();
				$post = $elementor_wp_query->post;
				setup_postdata( $post );
				$id = get_the_ID();
				$css_file = new Elementor\Core\Files\CSS\Post( $id );
				$css_file->enqueue();
			endwhile;
		}	
		wp_reset_postdata();
		return;
	}
}


/**
 * Add custom Page Builder CSS to the page
 * for custom backgrounds and other shortcode styling
 */

if(!function_exists('proradio_megafooter_vc_customcss')){
	function proradio_megafooter_vc_customcss(){
		// if( !function_exists('proradio_megafooter_posttype_name')){
		// 	return;
		// }
	
		// $args = array(
		// 	'post_type' 			=>  proradio_megafooter_posttype_name(),
		// 	'posts_per_page' 		=> -1,
		// 	'post_status' 			=> 'publish',
		// 	'paged' 				=> 1,
		// 	'suppress_filters' 		=> false,
		// 	'ignore_sticky_posts' 	=> 1,
		// 	'orderby' 				=> array( 'orderby' => array( 'menu_order' => 'ASC' ) )
		// );
		// // global $wp_query;
		// // wp_reset_postdata();
		// // wp_reset_query();
		// $wp_query = new WP_Query( $args );
		// $mf_shortcodes_custom_css_total = '';
		// /**
		//  * 
		//  */
		// if ( $wp_query->have_posts() ) { 
		// 	while ( $wp_query->have_posts() ) : $wp_query->the_post();
		// 		$post = $wp_query->post;
		// 		setup_postdata( $post );
		// 		$id = get_the_ID();
		// 		echo "\n /* =============================================== ".$id." ======== */ \n";
				
		// 		/**
		// 		 * WPBakery styles load
		// 		 */
		// 		$shortcodes_custom_css = get_post_meta( $id, '_wpb_shortcodes_custom_css', true ).' '.get_post_meta( $id, '_wpb_post_custom_css', true );
		// 		if ( ! empty( $shortcodes_custom_css ) ) {
		// 			$mf_shortcodes_custom_css_total .= $shortcodes_custom_css; // add the Visual Composer custom css to the page
		// 		}
		// 		/**
		// 		 * Elementor css load
		// 		 */
				
		// 		$css_file = new Elementor\Core\Files\CSS\Post( $id );
				

		// 		// var_dump($props);

		// 		echo '<pre>';
		// 		print_r($css_file);
		// 		echo '</pre>';


		// 		echo "\n /* REFLECTION = ".$id." ======== */ \n";
		// 		echo '<pre>';
		// 		$reflect = new ReflectionClass($css_file);
		// 		$props   = $reflect->getProperties();
		// 		print_r($props);
		// 		echo '</pre>';

		// 	endwhile;
		// }	
		// wp_reset_postdata();
		// return $mf_shortcodes_custom_css_total;
	}
}



/**
 * Create an options array with the list of available footers
 * Used by granular-settings.php
 */

if(!function_exists("proradio_megafooter_list")){
	function proradio_megafooter_list(){
		if( !function_exists('proradio_megafooter_posttype_name')){
			return;
		}
		if ( get_post_type( get_the_ID() ) === proradio_megafooter_posttype_name() ) {
			return;
		}
		$args = array(
			'post_type' 			=>  proradio_megafooter_posttype_name(),
			'posts_per_page' 		=> -1,
			'post_status' 			=> 'publish',
			'paged' 				=> 1,
			'suppress_filters' 		=> false,
			'ignore_sticky_posts' 	=> 1,
			'orderby' 				=> 'menu_order',
			'order'					=> 'ASC'
		);

		$wp_query = new WP_Query( $args );
		$array = array();
		/**
		 * Display the mega footer
		 */
		if ( $wp_query->have_posts() ) { 
			while ( $wp_query->have_posts() ) : $wp_query->the_post();
					global $post;
					$post = $wp_query->post;
					setup_postdata( $post );
					$array[] = array(
						'label' => esc_attr__( '[CUSTOM]', 'proradio-megafooter' ).esc_attr( ' ' . $post->ID.' - '.$post->post_title ),
						'value' => $post->ID
					);
			endwhile;
			wp_reset_postdata();
		}
		return $array;
	}
}

		