<?php
/*
Plugin Name: ProRadio Swipebox Photo And Video
Plugin URI: http://pro.radio/
Description: Enable the swipebox for the galleries
Author: QantumThemes
Version: PR.5.9.0
*/



/**
* Returns current plugin version.
* @return string Plugin version. Needs to stay here because of plugin file path
*/
if(!function_exists('proradio_swipebox_get_version')){
function proradio_swipebox_get_version() {
    if ( is_admin() ) {
        $plugin_data = get_plugin_data( __FILE__ );
        $plugin_version = $plugin_data['Version'];
    } else {
        $plugin_version = get_file_data( __FILE__ , array('Version'), 'plugin');
    }
 
    return $plugin_version[0];
}}
function proradio_swipebox_loader(){
	$version = 'NEW';
	wp_enqueue_script( 'swipebox',plugins_url( '/swipebox/'.$version.'/js/jquery.swipebox.min.js' , __FILE__ ), $deps = array("jquery"), proradio_swipebox_get_version(), $in_footer = true );
	wp_enqueue_script( 'proradio-swipebox',plugins_url( '/min/qt-swipebox-min.js' , __FILE__ ), $deps = array("jquery"), proradio_swipebox_get_version(), $in_footer = true );
	wp_enqueue_style( 'QtswipeStyle',plugins_url( '/swipebox/'.$version.'/css/swipebox.min.css' , __FILE__ ),proradio_swipebox_get_version());
}
add_action("wp_enqueue_scripts",'proradio_swipebox_loader');

