<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.6.5

*/
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if(!function_exists( 'proradio_template_post_masonry' )){
	function proradio_template_post_masonry( $atts = array() ){
		

		/*
		 *	Defaults
		 * 	All parameters can be bypassed by same attribute in the shortcode
		 */
		extract( shortcode_atts( array(
			// Query parameters
			'post_type' 			=> 'post',
			'include_by_id'			=> false,
			'custom_query'			=> false, // [Example year=2012]
			'tax_filter'			=> false,
'tax_filter_exc'		=> false, // Taxonomy filter [Example category:trending, post_tag:video]'
			'items_per_page'		=> '9',
			'orderby'				=> 'date',
			'order'					=> 'DESC',
			'meta_key'				=> false,
			'offset'				=> 0,
			'columns'				=> '3',
			'columnst'				=> '2',
			'exclude'				=> '',
			'e_loadmore'			=> false,
			'el_id'					=> uniqid( 'qt-post-masonry-'.get_the_ID() ), 
			'el_class'				=> '',
			'grid_id'				=> false // required for compatibility with WPBakery Page Builder
		), $atts ) );

		$list_id = md5( serialize($atts) );
		if(false === $grid_id){
			$grid_id = 'grid'.$el_id;
		}
		$grid_id = str_replace(':', '-', $grid_id);

		$paged = 1;
		include 'helpers/query-prep.php';
		$wp_query = new WP_Query( $args );

		// Max results value, used in pagination
		$max = $wp_query->max_num_pages;

		ob_start();
		if ( $wp_query->have_posts() ) : 
			?>
			
			<div id="<?php echo esc_attr( $grid_id ); ?>" class="proradio-container proradio-elementor-post-masonry">
				
				<div id="<?php echo esc_attr( $list_id ); ?>" class="proradio-loop proradio-row qt-masonry">
					<?php  
					/**
					 * Loop
					 */
					
					$cols = '4';
					if( $columns == '1' || $columns == '2' || $columns == '3' || $columns == '4' ){
						$cols = 12 / intval( $columns );
					}
					$colst = '6';
					if( $columnst == '1' || $columnst == '2' || $columnst == '3' ){
						$colst = 12 / intval( $columnst );
					}
					$item_classes = array(
						'proradio-m'. $colst ,
						'proradio-l'. $cols 
					);
					while ( $wp_query->have_posts() ) : $wp_query->the_post();
						$post = $wp_query->post;
							setup_postdata( $post );
							?>
							<div class="proradio-loop__item proradio-col proradio-col__post proradio-col__post proradio-s12 <?php echo esc_attr( implode(' ', $item_classes ) ); ?> qt-ms-item">
								<?php  
								get_template_part ('template-parts/post/post-vertical-masonry');
								?>
							</div>
							<?php 
							wp_reset_postdata();
					endwhile;
					include 'helpers/loadmore.php';
					?>
				</div>
				<hr class="proradio-spacer-s">
			</div>
			<?php
		else: 
			esc_html_e("Sorry, there is nothing for the moment.", "proradio");
		endif; 
		wp_reset_postdata();
		return ob_get_clean();
	}
}
