<?php  
/**
 * @package proradio
 * @version 2.0
 * Proxy switch
 * 
 **/
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}



/**
* ======================================
* proxy switch
* this switch is in the Welcome page
* ======================================
*/
if ( ! function_exists( 'proradio_snooze_updates' ) ) {
	add_action( 'admin_init', 'proradio_snooze_updates' );	
	function proradio_snooze_updates() {
		if( isset( $_GET ) && isset( $_POST ) ){
			if( isset( $_GET[ 'proradio-snooze-updates' ] ) && isset( $_POST[ 'proradio-hide-plugin-notifications' ] ) ){
				if ( wp_verify_nonce( $_POST[ 'proradio_snooze_switch_field' ], 'proradio_snooze_action') ) {
					$week = 60*60*24*7;
					if( $_POST[ 'proradio-hide-plugin-notifications' ] == 'hide') {
						set_transient('proradio-hide-plugins-notification-trans', 'hide', $week);
					}
					if( $_POST[ 'proradio-hide-plugin-notifications' ] == 'show') {
						delete_transient('proradio-hide-plugins-notification-trans');

					}
				}	
			}
		}
	}
}


/**
* ======================================
* Output the switch in the Welcome page
* ======================================
*/
if ( ! function_exists( 'proradio_snooze_updates_form' ) ) {
	function proradio_snooze_updates_form() {
		$hide_notifications = get_transient('proradio-hide-plugins-notification-trans');

		?>
		<h3><?php esc_html_e('Snooze plugin updates notification', 'proradio'); ?></h3>
		<p><?php esc_html_e('Not interested in seeing plugin updates or installation requests in your admin screen? Hide the notification for 7 days.', 'proradio'); ?></p>
		<form method="post" action="<?php echo admin_url() . 'admin.php?page=proradio-welcome&proradio-snooze-updates=1#proradio-snooze'; ?>" id="proradio-snooze">
			<?php 
			wp_nonce_field( 'proradio_snooze_action', 'proradio_snooze_switch_field' );
			if( $hide_notifications === 'hide' ){
				?>
				<style>#setting-error-tgmpa{display:  none;}</style>
				<p><?php 
				 esc_html_e('Notifications are:','proradio'); echo ' '; esc_html_e('disabled','proradio');
				?></p>
				<input type="hidden" name="proradio-hide-plugin-notifications" id="proradio-hide-plugin-notifications" value="show">
				<p><input type="submit" name="submit" value="<?php esc_html_e('Enable plugin updates notification', 'proradio'); ?>"  class="proradio-btn button button-primary"></p>
				<?php  
				
			} else {
				?>
				<p><?php 
				  esc_html_e('Notifications are:','proradio'); echo ' '; esc_html_e('enabled','proradio');
				?></p>
				<input type="hidden" name="proradio-hide-plugin-notifications" id="proradio-hide-plugin-notifications" value="hide">
				<p><input type="submit" name="submit" value="<?php esc_html_e('Snooze plugin updates notification', 'proradio'); ?>"  class="proradio-btn button button-error"></p>
				<?php  
			}
			?>
		</form>
		<?php 
	}
}