<?php
/**
 * CSS files.
 *
 * @version 1.0
 * @package xts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

return array(
	// Single product.
	'woo-single-prod-opt-review-images'                         => array(
		array(
			'title' => esc_html__( 'Single product review images', 'woodmart' ),
			'name'  => 'woo-single-prod-opt-review-images',
			'file'  => '/css/parts/woo-single-prod-opt-review-images',
		),
	),
	'woo-single-prod-el-reviews'                                => array(
		array(
			'title' => esc_html__( 'Single product reviews', 'woodmart' ),
			'name'  => 'woo-single-prod-el-reviews',
			'file'  => '/css/parts/woo-single-prod-el-reviews',
		),
	),
	'woo-single-prod-el-base'                                   => array(
		array(
			'title' => esc_html__( 'Single product elements base', 'woodmart' ),
			'name'  => 'woo-single-prod-el-base',
			'file'  => '/css/parts/woo-single-prod-el-base',
		),
	),
	'woo-single-prod-el-gallery'                                => array(
		array(
			'title' => esc_html__( 'Single product gallery', 'woodmart' ),
			'name'  => 'woo-single-prod-el-gallery',
			'file'  => '/css/parts/woo-single-prod-el-gallery',
			'rtl'   => true,
		),
	),
	'woo-single-prod-el-gallery-opt-thumb-left'                 => array(
		array(
			'title' => esc_html__( 'Single product gallery left', 'woodmart' ),
			'name'  => 'woo-single-prod-el-gallery-opt-thumb-left',
			'file'  => '/css/parts/woo-single-prod-el-gallery-opt-thumb-left',
			'rtl'   => true,
		),
	),
	'woo-single-prod-el-gallery-opt-thumb-columns'              => array(
		array(
			'title' => esc_html__( 'Single product gallery columns', 'woodmart' ),
			'name'  => 'woo-single-prod-el-gallery-opt-thumb-columns',
			'file'  => '/css/parts/woo-single-prod-el-gallery-opt-thumb-columns',
			'rtl'   => true,
		),
	),
	'woo-single-prod-el-navigation'                             => array(
		array(
			'title' => esc_html__( 'Single product navigation', 'woodmart' ),
			'name'  => 'woo-single-prod-el-navigation',
			'file'  => '/css/parts/woo-single-prod-el-navigation',
			'rtl'   => true,
		),
	),
	'woo-single-prod-el-tabs-opt-layout-tabs'                   => array(
		array(
			'title' => esc_html__( 'Single product tabs', 'woodmart' ),
			'name'  => 'woo-single-prod-el-tabs-opt-layout-tabs',
			'file'  => '/css/parts/woo-single-prod-el-tabs-opt-layout-tabs',
		),
	),
	'woo-single-prod-el-tabs-opt-layout-all-open'               => array(
		array(
			'title' => esc_html__( 'Single product tabs all-open', 'woodmart' ),
			'name'  => 'woo-single-prod-el-tabs-opt-layout-all-open',
			'file'  => '/css/parts/woo-single-prod-el-tabs-opt-layout-all-open',
		),
	),
	'woo-single-prod-el-grouped'                                => array(
		array(
			'title' => esc_html__( 'Single grouped product', 'woodmart' ),
			'name'  => 'woo-single-prod-el-grouped',
			'file'  => '/css/parts/woo-single-prod-el-grouped',
		),
	),
	'woo-single-prod-opt-gallery-full-width'                    => array(
		array(
			'title' => esc_html__( 'Single product gallery full width', 'woodmart' ),
			'name'  => 'woo-single-prod-opt-gallery-full-width',
			'file'  => '/css/parts/woo-single-prod-opt-gallery-full-width',
		),
	),
	'woo-single-prod-opt-base'                                  => array(
		array(
			'title' => esc_html__( 'Single product base options', 'woodmart' ),
			'name'  => 'woo-single-prod-opt-base',
			'file'  => '/css/parts/woo-single-prod-opt-base',
		),
	),
	'woo-single-prod-design-centered'                           => array(
		array(
			'title' => esc_html__( 'Single product design centered', 'woodmart' ),
			'name'  => 'woo-single-prod-design-centered',
			'file'  => '/css/parts/woo-single-prod-design-centered',
		),
	),
	'woo-mod-shop-attributes'                                   => array(
		array(
			'title' => esc_html__( 'Single product shop attributes mod', 'woodmart' ),
			'name'  => 'woo-mod-shop-attributes',
			'file'  => '/css/parts/woo-mod-shop-attributes',
			'rtl'   => true,
		),
	),
	'woo-mod-shop-loop-head'                                    => array(
		array(
			'title' => esc_html__( 'Shop loop head mod', 'woodmart' ),
			'name'  => 'woo-mod-shop-loop-head',
			'file'  => '/css/parts/woo-mod-shop-loop-head',
			'rtl'   => true,
		),
	),
	'woo-mod-checkout-steps'                                    => array(
		array(
			'title' => esc_html__( 'WooCommerce mod checkout steps', 'woodmart' ),
			'name'  => 'woo-mod-checkout-steps',
			'file'  => '/css/parts/woo-mod-checkout-steps',
			'rtl'   => true,
		),
	),
	'woo-mod-progress-bar'                                => array(
		array(
			'title' => esc_html__( 'WooCommerce mod stock progress bar', 'woodmart' ),
			'name'  => 'woo-mod-progress-bar',
			'file'  => '/css/parts/woo-mod-progress-bar',
		),
	),
	'woo-mod-variation-form'                                    => array(
		array(
			'title' => esc_html__( 'WooCommerce mod variation form', 'woodmart' ),
			'name'  => 'woo-mod-variation-form',
			'file'  => '/css/parts/woo-mod-variation-form',
			'rtl'   => true,
		),
	),
	'woo-mod-variation-form-single'                             => array(
		array(
			'title' => esc_html__( 'WooCommerce mod variation form single', 'woodmart' ),
			'name'  => 'woo-mod-variation-form-single',
			'file'  => '/css/parts/woo-mod-variation-form-single',
			'rtl'   => true,
		),
	),
	'woo-mod-stock-status'                                      => array(
		array(
			'title' => esc_html__( 'WooCommerce mod stock status', 'woodmart' ),
			'name'  => 'woo-mod-stock-status',
			'file'  => '/css/parts/woo-mod-stock-status',
		),
	),
	'woo-mod-shop-table'                                        => array(
		array(
			'title' => esc_html__( 'WooCommerce mod shop table', 'woodmart' ),
			'name'  => 'woo-mod-shop-table',
			'file'  => '/css/parts/woo-mod-shop-table',
			'rtl'   => true,
		),
	),
	'woo-mod-quantity'                                          => array(
		array(
			'title' => esc_html__( 'WooCommerce mod quantity', 'woodmart' ),
			'name'  => 'woo-mod-quantity',
			'file'  => '/css/parts/woo-mod-quantity',
		),
	),
	'woo-mod-quantity-overlap'                                  => array(
		array(
			'title' => esc_html__( 'WooCommerce mod quantity overlap', 'woodmart' ),
			'name'  => 'woo-mod-quantity-overlap',
			'file'  => '/css/parts/woo-mod-quantity-overlap',
			'rtl'   => true,
		),
	),
	'woo-mod-grid'                                              => array(
		array(
			'title' => esc_html__( 'WooCommerce mod grid', 'woodmart' ),
			'name'  => 'woo-mod-grid',
			'file'  => '/css/parts/woo-mod-grid',
			'rtl'   => true,
		),
	),
	'woo-mod-product-swatches'                                  => array(
		array(
			'title' => esc_html__( 'WooCommerce mod product swatches', 'woodmart' ),
			'name'  => 'woo-mod-product-swatches',
			'file'  => '/css/parts/woo-mod-product-swatches',
			'rtl'   => true,
		),
	),
	'mod-more-description'                                      => array(
		array(
			'title' => esc_html__( 'Mod more description', 'woodmart' ),
			'name'  => 'mod-more-description',
			'file'  => '/css/parts/mod-more-description',
		),
	),
	'mod-comments'                                              => array(
		array(
			'title' => esc_html__( 'Mod comments', 'woodmart' ),
			'name'  => 'mod-comments',
			'file'  => '/css/parts/mod-comments',
			'rtl'   => true,
		),
	),
	'mod-nav-vertical'                                          => array(
		array(
			'title' => esc_html__( 'Mod navigation vertical', 'woodmart' ),
			'name'  => 'mod-nav-vertical',
			'file'  => '/css/parts/mod-nav-vertical',
			'rtl'   => true,
		),
	),
	'mod-nav-menu-label'                                        => array(
		array(
			'title' => esc_html__( 'Mod nav menu label', 'woodmart' ),
			'name'  => 'mod-nav-menu-label',
			'file'  => '/css/parts/mod-nav-menu-label',
		),
	),
	// Widgets.
	'widget-calendar'                                           => array(
		array(
			'title' => esc_html__( 'Widget calendar', 'woodmart' ),
			'name'  => 'widget-calendar',
			'file'  => '/css/parts/widget-calendar',
		),
	),
	'widget-rss'                                                => array(
		array(
			'title' => esc_html__( 'Widget rss', 'woodmart' ),
			'name'  => 'widget-rss',
			'file'  => '/css/parts/widget-rss',
		),
	),
	'widget-tag-cloud'                                          => array(
		array(
			'title' => esc_html__( 'Widget tag cloud', 'woodmart' ),
			'name'  => 'widget-tag-cloud',
			'file'  => '/css/parts/widget-tag-cloud',
		),
	),
	'widget-recent-post-comments'                               => array(
		array(
			'title' => esc_html__( 'Widget recent post or comments', 'woodmart' ),
			'name'  => 'widget-recent-post-comments',
			'file'  => '/css/parts/widget-recent-post-comments',
			'rtl'   => true,
		),
	),
	'widget-wd-recent-posts'                                    => array(
		array(
			'title' => esc_html__( '[Woodmart] Widget recent post', 'woodmart' ),
			'name'  => 'widget-wd-recent-posts',
			'file'  => '/css/parts/widget-wd-recent-posts',
		),
	),
	'widget-nav-mega-menu'                                      => array(
		array(
			'title' => esc_html__( '[Woodmart] Widget mega menu', 'woodmart' ),
			'name'  => 'widget-nav-mega-menu',
			'file'  => '/css/parts/widget-nav-mega-menu',
		),
	),
	'widget-nav'                                                => array(
		array(
			'title' => esc_html__( '[Woodmart] Widget navigation', 'woodmart' ),
			'name'  => 'widget-nav',
			'file'  => '/css/parts/widget-nav',
		),
	),
	'widget-wd-layered-nav'                                     => array(
		array(
			'title' => esc_html__( '[Woodmart] Widget layered navigation', 'woodmart' ),
			'name'  => 'widget-wd-layered-nav',
			'file'  => '/css/parts/woo-widget-wd-layered-nav',
		),
	),
	'widget-product-cat'                                        => array(
		array(
			'title' => esc_html__( '[Woodmart] Widget product categories', 'woodmart' ),
			'name'  => 'widget-product-cat',
			'file'  => '/css/parts/woo-widget-product-cat',
			'rtl'   => true,
		),
	),
	'widget-layered-nav-stock-status'                           => array(
		array(
			'title' => esc_html__( 'Widget layered navigation & stock status', 'woodmart' ),
			'name'  => 'widget-layered-nav-stock-status',
			'file'  => '/css/parts/woo-widget-layered-nav-stock-status',
			'rtl'   => true,
		),
	),
	'widget-active-filters'                                     => array(
		array(
			'title' => esc_html__( 'Widget active filters', 'woodmart' ),
			'name'  => 'widget-active-filters',
			'file'  => '/css/parts/woo-widget-active-filters',
			'rtl'   => true,
		),
	),
	'widget-price-filter'                                       => array(
		array(
			'title' => esc_html__( '[Woodmart] Widget price filter', 'woodmart' ),
			'name'  => 'widget-price-filter',
			'file'  => '/css/parts/woo-widget-price-filter',
		),
	),
	'widget-product-list'                                       => array(
		array(
			'title' => esc_html__( 'Widget products', 'woodmart' ),
			'name'  => 'widget-product-list',
			'file'  => '/css/parts/woo-widget-product-list',
			'rtl'   => true,
		),
	),
	'widget-product-upsells'                                    => array(
		array(
			'title' => esc_html__( 'Widget products upsells', 'woodmart' ),
			'name'  => 'widget-product-upsells',
			'file'  => '/css/parts/woo-widget-upsells',
		),
	),
	'widget-shopping-cart'                                      => array(
		array(
			'title' => esc_html__( 'Widget shopping cart', 'woodmart' ),
			'name'  => 'widget-shopping-cart',
			'file'  => '/css/parts/woo-widget-shopping-cart',
			'rtl'   => true,
		),
	),
	'widget-slider-price-filter'                                => array(
		array(
			'title' => esc_html__( 'Widget price filter slider', 'woodmart' ),
			'name'  => 'widget-slider-price-filter',
			'file'  => '/css/parts/woo-widget-slider-price-filter',
		),
	),
	'widget-user-panel'                                         => array(
		array(
			'title' => esc_html__( 'Widget user panel', 'woodmart' ),
			'name'  => 'widget-user-panel',
			'file'  => '/css/parts/woo-widget-user-panel',
		),
	),
	'widget-woo-other'                                          => array(
		array(
			'title' => esc_html__( 'Widget woocommerce other', 'woodmart' ),
			'name'  => 'widget-woo-other',
			'file'  => '/css/parts/woo-widget-other',
		),
	),
	// Blog.
	'blog-loop-base'                                            => array(
		array(
			'title' => esc_html__( 'Blog loop base', 'woodmart' ),
			'name'  => 'blog-loop-base',
			'file'  => '/css/parts/blog-loop-base',
			'rtl'   => true,
		),
	),
	'blog-loop-base-old'                                        => array(
		array(
			'title' => esc_html__( 'Blog loop base old', 'woodmart' ),
			'name'  => 'blog-loop-base-old',
			'file'  => '/css/parts/blog-loop-base-old',
			'rtl'   => true,
		),
	),
	'blog-loop-design-meta-image'                               => array(
		array(
			'title' => esc_html__( 'Blog loop design meta image', 'woodmart' ),
			'name'  => 'blog-loop-design-meta-image',
			'file'  => '/css/parts/blog-loop-design-meta-image',
			'rtl'   => true,
		),
	),
	'blog-loop-design-default'                                  => array(
		array(
			'title' => esc_html__( 'Blog loop design default', 'woodmart' ),
			'name'  => 'blog-loop-design-default',
			'file'  => '/css/parts/blog-loop-design-default',
		),
	),
	'blog-loop-design-default-alt'                              => array(
		array(
			'title' => esc_html__( 'Blog loop design default alternative', 'woodmart' ),
			'name'  => 'blog-loop-design-default-alt',
			'file'  => '/css/parts/blog-loop-design-default-alt',
			'rtl'   => true,
		),
	),
	'blog-loop-design-small-img-chess'                          => array(
		array(
			'title' => esc_html__( 'Blog loop design small images & chess', 'woodmart' ),
			'name'  => 'blog-loop-design-small-img-chess',
			'file'  => '/css/parts/blog-loop-design-smallimg-chess',
			'rtl'   => true,
		),
	),
	'blog-loop-design-mask'                                     => array(
		array(
			'title' => esc_html__( 'Blog loop design mask', 'woodmart' ),
			'name'  => 'blog-loop-design-mask',
			'file'  => '/css/parts/blog-loop-design-mask',
			'rtl'   => true,
		),
	),
	'blog-loop-design-masonry'                                  => array(
		array(
			'title' => esc_html__( 'Blog loop design masonry', 'woodmart' ),
			'name'  => 'blog-loop-design-masonry',
			'file'  => '/css/parts/blog-loop-design-masonry',
			'rtl'   => true,
		),
	),
	'blog-single-base'                                          => array(
		array(
			'title' => esc_html__( 'Blog single', 'woodmart' ),
			'name'  => 'blog-single-base',
			'file'  => '/css/parts/blog-single-base',
			'rtl'   => true,
		),
	),
	// Modules.
	'animations'                                                => array(
		array(
			'title' => esc_html__( 'Animations module', 'woodmart' ),
			'name'  => 'animations',
			'file'  => '/css/parts/mod-animations',
		),
	),
	'notices-fixed'                                             => array(
		array(
			'title' => esc_html__( 'Sticky notifications module', 'woodmart' ),
			'name'  => 'notices-fixed',
			'file'  => '/css/parts/woo-opt-sticky-notices',
			'rtl'   => true,
		),
	),
	'page-navigation'                                           => array(
		array(
			'title' => esc_html__( 'Page navigation', 'woodmart' ),
			'name'  => 'page-navigation',
			'file'  => '/css/parts/mod-page-navigation',
			'rtl'   => true,
		),
	),
	'load-more-button'                                          => array(
		array(
			'title' => esc_html__( 'Load more button', 'woodmart' ),
			'name'  => 'load-more-button',
			'file'  => '/css/parts/mod-load-more-button',
			'rtl'   => true,
		),
	),
	'sticky-loader'                                             => array(
		array(
			'title' => esc_html__( 'Sticky loader', 'woodmart' ),
			'name'  => 'sticky-loader',
			'file'  => '/css/parts/mod-sticky-loader',
		),
	),
	// Footer.
	'footer-base'                                               => array(
		array(
			'title' => esc_html__( 'Footer base', 'woodmart' ),
			'name'  => 'footer-base',
			'file'  => '/css/parts/footer-base',
			'rtl'   => true,
		),
	),
	'footer-sticky'                                             => array(
		array(
			'title' => esc_html__( 'Footer sticky', 'woodmart' ),
			'name'  => 'footer-sticky',
			'file'  => '/css/parts/footer-sticky',
		),
	),
	// Header.
	'header-base'                                               => array(
		array(
			'title' => esc_html__( 'Header base', 'woodmart' ),
			'name'  => 'header-base',
			'file'  => '/css/parts/header-base',
			'rtl'   => true,
		),
		array(
			'title' => esc_html__( 'Module tools', 'woodmart' ),
			'name'  => 'mod-tools',
			'file'  => '/css/parts/mod-tools',
			'rtl'   => true,
		),
	),
	'header-boxed'                                              => array(
		array(
			'title' => esc_html__( 'Header boxed', 'woodmart' ),
			'name'  => 'header-boxed',
			'file'  => '/css/parts/header-boxed',
		),
	),
	'header-elements-base'                                      => array(
		array(
			'title' => esc_html__( 'Header base elements', 'woodmart' ),
			'name'  => 'header-elements-base',
			'file'  => '/css/parts/header-el-base',
			'rtl'   => true,
		),
	),
	'header-fullscreen-menu'                                    => array(
		array(
			'title' => esc_html__( 'Header fullscreen menu', 'woodmart' ),
			'name'  => 'fullscreen-menu',
			'file'  => '/css/parts/header-el-fullscreen-menu',
			'rtl'   => true,
		),
	),
	'header-categories-nav'                                     => array(
		array(
			'title' => esc_html__( 'Header category navigation', 'woodmart' ),
			'name'  => 'header-categories-nav',
			'file'  => '/css/parts/header-el-category-nav',
			'rtl'   => true,
		),
	),
	'header-my-account'                                         => array(
		array(
			'title' => esc_html__( 'Header my account', 'woodmart' ),
			'name'  => 'header-my-account',
			'file'  => '/css/parts/header-el-my-account',
			'rtl'   => true,
		),
	),
	'header-my-account-dropdown'                                => array(
		array(
			'title' => esc_html__( 'Header my account dropdown', 'woodmart' ),
			'name'  => 'header-my-account-dropdown',
			'file'  => '/css/parts/header-el-my-account-dropdown',
			'rtl'   => true,
		),
	),
	'header-my-account-sidebar'                                 => array(
		array(
			'title' => esc_html__( 'Header my account sidebar', 'woodmart' ),
			'name'  => 'header-my-account-sidebar',
			'file'  => '/css/parts/header-el-my-account-sidebar',
		),
	),
	'header-search'                                             => array(
		array(
			'title' => esc_html__( 'Header search', 'woodmart' ),
			'name'  => 'header-search',
			'file'  => '/css/parts/header-el-search',
			'rtl'   => true,
		),
	),
	'header-search-form'                                        => array(
		array(
			'title' => esc_html__( 'Header search form', 'woodmart' ),
			'name'  => 'header-search-form',
			'file'  => '/css/parts/header-el-search-form',
			'rtl'   => true,
		),
	),
	'header-search-fullscreen'                                  => array(
		array(
			'title' => esc_html__( 'Header search fullscreen', 'woodmart' ),
			'name'  => 'header-search-fullscreen',
			'file'  => '/css/parts/header-el-search-fullscreen-general',
			'rtl'   => true,
		),
	),
	'header-search-fullscreen-1'                                => array(
		array(
			'title' => esc_html__( 'Header search fullscreen 1', 'woodmart' ),
			'name'  => 'header-search-fullscreen-1',
			'file'  => '/css/parts/header-el-search-fullscreen-1',
			'rtl'   => true,
		),
	),
	'header-search-fullscreen-2'                                => array(
		array(
			'title' => esc_html__( 'Header search fullscreen 2', 'woodmart' ),
			'name'  => 'header-search-fullscreen-2',
			'file'  => '/css/parts/header-el-search-fullscreen-2',
			'rtl'   => true,
		),
	),
	'wd-search-form'                                            => array(
		array(
			'title' => esc_html__( 'Woodmart search form', 'woodmart' ),
			'name'  => 'wd-search-form',
			'file'  => '/css/parts/wd-search-form',
			'rtl'   => true,
		),
	),
	'wd-search-cat'                                             => array(
		array(
			'title' => esc_html__( 'Woodmart search form with categories', 'woodmart' ),
			'name'  => 'wd-search-cat',
			'file'  => '/css/parts/wd-search-cat',
			'rtl'   => true,
		),
	),
	'wd-search-results'                                         => array(
		array(
			'title' => esc_html__( 'Woodmart search form with ajax', 'woodmart' ),
			'name'  => 'wd-search-results',
			'file'  => '/css/parts/wd-search-results',
			'rtl'   => true,
		),
	),
	'header-cart'                                               => array(
		array(
			'title' => esc_html__( 'Header cart', 'woodmart' ),
			'name'  => 'header-cart',
			'file'  => '/css/parts/header-el-cart',
			'rtl'   => true,
		),
	),
	'header-cart-design-3'                                      => array(
		array(
			'title' => esc_html__( 'Header cart design 3', 'woodmart' ),
			'name'  => 'header-cart-design-3',
			'file'  => '/css/parts/header-el-cart-design-3',
			'rtl'   => true,
		),
	),
	'header-cart-side'                                          => array(
		array(
			'title' => esc_html__( 'Header cart-side', 'woodmart' ),
			'name'  => 'header-cart-side',
			'file'  => '/css/parts/header-el-cart-side',
			'rtl'   => true,
		),
	),
	'header-el-category-more-btn'                               => array(
		array(
			'title' => esc_html__( 'Header element category more button', 'woodmart' ),
			'name'  => 'header-el-category-more-btn',
			'file'  => '/css/parts/header-el-category-more-btn',
		),
	),
	// Layouts.
	'layout-wrapper-boxed'                                      => array(
		array(
			'title' => esc_html__( 'Layout wrapper boxed', 'woodmart' ),
			'name'  => 'layout-wrapper-boxed',
			'file'  => '/css/parts/layout-wrapper-boxed',
			'rtl'   => true,
		),
	),
	// Woocommerce options.
	'woo-opt-free-progress-bar'                                          => array(
		array(
			'title' => esc_html__( 'Free shipping progress bar', 'woodmart' ),
			'name'  => 'woo-opt-free-progress-bar',
			'file'  => '/css/parts/woo-opt-free-progress-bar',
		),
	),
	'woo-opt-visits-count'                                  => array(
		array(
			'title' => esc_html__( 'Count product visits', 'woodmart' ),
			'name'  => 'woo-opt-visits-count',
			'file'  => '/css/parts/woo-opt-visits-count',
		),
	),
	'woo-opt-stretch-cont'                                          => array(
		array(
			'title' => esc_html__( 'Product stretch content', 'woodmart' ),
			'name'  => 'woo-opt-stretch-cont',
			'file'  => '/css/parts/woo-opt-stretch-cont',
		),
	),
	'bordered-product'                                          => array(
		array(
			'title' => esc_html__( 'Bordered product', 'woodmart' ),
			'name'  => 'bordered-product',
			'file'  => '/css/parts/woo-opt-bordered-product',
			'rtl'   => true,
		),
	),
	'shop-filter-area'                                          => array(
		array(
			'title' => esc_html__( 'Shop filter area', 'woodmart' ),
			'name'  => 'shop-filter-area',
			'file'  => '/css/parts/woo-shop-el-filters-area',
		),
	),
	'shop-title-categories'                                     => array(
		array(
			'title' => esc_html__( 'Shop page title categories', 'woodmart' ),
			'name'  => 'shop-title-categories',
			'file'  => '/css/parts/woo-categories-loop-nav',
		),
	),
	'woo-categories-loop-nav-mobile-accordion'                  => array(
		array(
			'title' => esc_html__( 'Shop mobile accordion categories', 'woodmart' ),
			'name'  => 'woo-categories-loop-nav-mobile-accordion',
			'file'  => '/css/parts/woo-categories-loop-nav-mobile-accordion',
		),
	),
	// Woocommerce.
	'colorbox-popup'                                            => array(
		array(
			'title' => esc_html__( 'Color box popup library', 'woodmart' ),
			'name'  => 'colorbox-popup',
			'file'  => '/css/parts/woo-lib-colorbox-popup',
		),
	),
	'woocommerce-base'                                          => array(
		array(
			'title' => esc_html__( 'WooCommerce base', 'woodmart' ),
			'name'  => 'woocommerce-base',
			'file'  => '/css/parts/woocommerce-base',
			'rtl'   => true,
		),
	),
	'brands'                                                    => array(
		array(
			'title' => esc_html__( 'Brands element', 'woodmart' ),
			'name'  => 'brands',
			'file'  => '/css/parts/el-brand',
			'rtl'   => true,
		),
	),
	'product-tabs'                                              => array(
		array(
			'title' => esc_html__( 'Product tabs element', 'woodmart' ),
			'name'  => 'product-tabs',
			'file'  => '/css/parts/el-product-tabs',
			'rtl'   => true,
		),
	),
	'add-to-cart-popup'                                         => array(
		array(
			'title' => esc_html__( 'Add to cart popup option', 'woodmart' ),
			'name'  => 'add-to-cart-popup',
			'file'  => '/css/parts/woo-opt-add-to-cart-popup',
		),
	),
	'size-guide'                                                => array(
		array(
			'title' => esc_html__( 'Size guide', 'woodmart' ),
			'name'  => 'size-guide',
			'file'  => '/css/parts/woo-opt-size-guide',
		),
	),
	'sticky-add-to-cart'                                        => array(
		array(
			'title' => esc_html__( 'Sticky add to cart', 'woodmart' ),
			'name'  => 'sticky-add-to-cart',
			'file'  => '/css/parts/woo-opt-sticky-add-to-cart',
			'rtl'   => true,
		),
	),
	'page-cart'                                                 => array(
		array(
			'title' => esc_html__( 'Cart page', 'woodmart' ),
			'name'  => 'page-cart',
			'file'  => '/css/parts/woo-page-cart',
			'rtl'   => true,
		),
	),
	'woo-page-cart-predefined'                                  => array(
		array(
			'title' => esc_html__( 'Cart page predefined', 'woodmart' ),
			'name'  => 'woo-page-cart-predefined',
			'file'  => '/css/parts/woo-page-cart-predefined',
		),
	),
	'woo-page-cart-builder'                                     => array(
		array(
			'title' => esc_html__( 'Cart page builder', 'woodmart' ),
			'name'  => 'woo-page-cart-builder',
			'file'  => '/css/parts/woo-page-cart-builder',
		),
	),
	'page-checkout'                                             => array(
		array(
			'title' => esc_html__( 'Checkout page', 'woodmart' ),
			'name'  => 'page-checkout',
			'file'  => '/css/parts/woo-page-checkout',
			'rtl'   => true,
		),
	),
	'woo-page-checkout-predefined'                              => array(
		array(
			'title' => esc_html__( 'Checkout predefined page', 'woodmart' ),
			'name'  => 'woo-page-checkout-predefined',
			'file'  => '/css/parts/woo-page-checkout-predefined',
		),
	),
	'woo-page-checkout-builder'                                 => array(
		array(
			'title' => esc_html__( 'Checkout builder page', 'woodmart' ),
			'name'  => 'woo-page-checkout-builder',
			'file'  => '/css/parts/woo-page-checkout-builder',
		),
	),
	'woo-page-order-complete'                                   => array(
		array(
			'title' => esc_html__( 'Order complete page', 'woodmart' ),
			'name'  => 'woo-page-order-complete',
			'file'  => '/css/parts/woo-page-order-complete',
		),
	),
	'woo-page-empty-page'                                       => array(
		array(
			'title' => esc_html__( 'WooCommerce page empty page', 'woodmart' ),
			'name'  => 'woo-page-empty-page',
			'file'  => '/css/parts/woo-page-empty-page',
		),
	),
	'woo-page-lost-password'                                    => array(
		array(
			'title' => esc_html__( 'WooCommerce page lost password', 'woodmart' ),
			'name'  => 'woo-page-lost-password',
			'file'  => '/css/parts/woo-page-lost-password',
		),
	),
	'woo-el-track-order'                                        => array(
		array(
			'title' => esc_html__( 'WooCommerce element track order', 'woodmart' ),
			'name'  => 'woo-el-track-order',
			'file'  => '/css/parts/woo-el-track-order',
		),
	),
	'woo-mod-order-details'                                     => array(
		array(
			'title' => esc_html__( 'WooCommerce order details mod', 'woodmart' ),
			'name'  => 'woo-mod-order-details',
			'file'  => '/css/parts/woo-mod-order-details',
		),
	),
	'page-compare'                                              => array(
		array(
			'title' => esc_html__( 'Compare page', 'woodmart' ),
			'name'  => 'page-compare',
			'file'  => '/css/parts/woo-page-compare',
		),
	),
	'page-wishlist'                                             => array(
		array(
			'title' => esc_html__( 'Wishlist page', 'woodmart' ),
			'name'  => 'page-wishlist',
			'file'  => '/css/parts/woo-page-wishlist',
		),
	),
	'page-my-account'                                           => array(
		array(
			'title' => esc_html__( 'My account page', 'woodmart' ),
			'name'  => 'page-my-account',
			'file'  => '/css/parts/woo-page-my-account',
			'rtl'   => true,
		),
	),
	'woo-shop-builder'                                          => array(
		array(
			'title' => esc_html__( 'Shop builder', 'woodmart' ),
			'name'  => 'woo-shop-builder',
			'file'  => '/css/parts/woo-shop-builder',
		),
	),
	'woo-shop-predefined'                                       => array(
		array(
			'title' => esc_html__( 'Shop predefined', 'woodmart' ),
			'name'  => 'woo-shop-predefined',
			'file'  => '/css/parts/woo-shop-predefined',
		),
	),
	'woo-shop-opt-shop-ajax'                                    => array(
		array(
			'title' => esc_html__( 'Shop ajax option', 'woodmart' ),
			'name'  => 'woo-shop-opt-shop-ajax',
			'file'  => '/css/parts/woo-shop-opt-shop-ajax',
		),
	),
	'woo-shop-el-active-filters'                                => array(
		array(
			'title' => esc_html__( 'Shop active filters element', 'woodmart' ),
			'name'  => 'woo-shop-el-active-filters',
			'file'  => '/css/parts/woo-shop-el-active-filters',
		),
	),
	'woo-shop-el-order-by'                                      => array(
		array(
			'title' => esc_html__( 'Shop order by element', 'woodmart' ),
			'name'  => 'woo-shop-el-order-by',
			'file'  => '/css/parts/woo-shop-el-order-by',
			'rtl'   => true,
		),
	),
	'woo-shop-el-products-per-page'                             => array(
		array(
			'title' => esc_html__( 'Shop products per page element', 'woodmart' ),
			'name'  => 'woo-shop-el-products-per-page',
			'file'  => '/css/parts/woo-shop-el-products-per-page',
		),
	),
	'woo-shop-el-products-view'                                 => array(
		array(
			'title' => esc_html__( 'Shop products view element', 'woodmart' ),
			'name'  => 'woo-shop-el-products-view',
			'file'  => '/css/parts/woo-shop-el-products-view',
		),
	),
	'woo-shop-page-title'                                       => array(
		array(
			'title' => esc_html__( 'Shop products page title element', 'woodmart' ),
			'name'  => 'woo-shop-page-title',
			'file'  => '/css/parts/woo-shop-page-title',
			'rtl'   => true,
		),
	),
	'woo-shop-opt-without-title'                                => array(
		array(
			'title' => esc_html__( 'Shop opt without title', 'woodmart' ),
			'name'  => 'woo-shop-opt-without-title',
			'file'  => '/css/parts/woo-shop-opt-without-title',
		),
	),
	'product-loop'                                              => array(
		array(
			'title' => esc_html__( 'Product loop', 'woodmart' ),
			'name'  => 'product-loop',
			'file'  => '/css/parts/woo-product-loop',
			'rtl'   => true,
		),
	),
	'woo-prod-loop-small'                                       => array(
		array(
			'title' => esc_html__( 'Product hover small', 'woodmart' ),
			'name'  => 'woo-prod-loop-small',
			'file'  => '/css/parts/woo-prod-loop-small',
		),
	),
	'product-loop-button-info-alt'                              => array(
		array(
			'title' => esc_html__( 'Product loop "Standard button" & "Full info on hover"', 'woodmart' ),
			'name'  => 'product-loop-button-info-alt',
			'file'  => '/css/parts/woo-product-loop-button-info-alt',
			'rtl'   => true,
		),
	),
	'product-loop-info'                                         => array(
		array(
			'title' => esc_html__( 'Product loop "Full info on image"', 'woodmart' ),
			'name'  => 'product-loop-info',
			'file'  => '/css/parts/woo-product-loop-info',
			'rtl'   => true,
		),
	),
	'product-loop-alt'                                          => array(
		array(
			'title' => esc_html__( 'Product loop "Icons and add to cart on hover"', 'woodmart' ),
			'name'  => 'product-loop-alt',
			'file'  => '/css/parts/woo-product-loop-alt',
			'rtl'   => true,
		),
	),
	'product-loop-icons'                                        => array(
		array(
			'title' => esc_html__( 'Product loop "Icons on hover"', 'woodmart' ),
			'name'  => 'product-loop-icons',
			'file'  => '/css/parts/woo-product-loop-icons',
		),
	),
	'product-loop-quick'                                        => array(
		array(
			'title' => esc_html__( 'Product loop "Quick"', 'woodmart' ),
			'name'  => 'product-loop-quick',
			'file'  => '/css/parts/woo-product-loop-quick',
			'rtl'   => true,
		),
	),
	'product-loop-base'                                         => array(
		array(
			'title' => esc_html__( 'Product loop "Show summary on hover"', 'woodmart' ),
			'name'  => 'product-loop-base',
			'file'  => '/css/parts/woo-product-loop-base',
			'rtl'   => true,
		),
	),
	'product-loop-standard'                                     => array(
		array(
			'title' => esc_html__( 'Product loop "Standard button"', 'woodmart' ),
			'name'  => 'product-loop-standard',
			'file'  => '/css/parts/woo-product-loop-standard',
			'rtl'   => true,
		),
	),
	'product-loop-tiled'                                        => array(
		array(
			'title' => esc_html__( 'Product loop "Tiled"', 'woodmart' ),
			'name'  => 'product-loop-tiled',
			'file'  => '/css/parts/woo-product-loop-tiled',
		),
	),
	'product-loop-fw-button'                                  => array(
		array(
			'title' => esc_html__( 'Product loop "Full width button"', 'woodmart' ),
			'name'  => 'product-loop-fw-button',
			'file'  => '/css/parts/woo-prod-loop-fw-button',
			'rtl'   => true,
		),
	),
	'product-loop-list'                                         => array(
		array(
			'title' => esc_html__( 'Product loop "List"', 'woodmart' ),
			'name'  => 'product-loop-list',
			'file'  => '/css/parts/woo-product-loop-list',
			'rtl'   => true,
		),
	),
	'select2'                                                   => array(
		array(
			'title' => esc_html__( 'Select2 library', 'woodmart' ),
			'name'  => 'select2',
			'file'  => '/css/parts/woo-lib-select2',
			'rtl'   => true,
		),
	),
	'woo-categories-loop'                                       => array(
		array(
			'title' => esc_html__( 'Categories loop', 'woodmart' ),
			'name'  => 'woo-categories-loop',
			'file'  => '/css/parts/woo-categories-loop',
		),
	),
	'woo-categories-loop-mask-subcat'                           => array(
		array(
			'title' => esc_html__( 'Categories design mask with subcategories', 'woodmart' ),
			'name'  => 'woo-categories-loop-mask-subcat',
			'file'  => '/css/parts/woo-categories-loop-mask-subcat',
		),
	),
	'woo-categories-loop-layout-masonry'                        => array(
		array(
			'title' => esc_html__( 'Categories layout masonry or carousel', 'woodmart' ),
			'name'  => 'woo-categories-loop-layout-masonry',
			'file'  => '/css/parts/woo-categories-loop-layout-masonry',
		),
	),
	'categories-loop'                                           => array(
		array(
			'title' => esc_html__( 'Categories loop', 'woodmart' ),
			'name'  => 'categories-loop',
			'file'  => '/css/parts/woo-categories-loop-old',
		),
	),
	'categories-loop-default'                                   => array(
		array(
			'title' => esc_html__( 'Categories loop default', 'woodmart' ),
			'name'  => 'categories-loop-default',
			'file'  => '/css/parts/woo-categories-loop-default-old',
			'rtl'   => true,
		),
	),
	'categories-loop-center'                                    => array(
		array(
			'title' => esc_html__( 'Categories loop center title', 'woodmart' ),
			'name'  => 'categories-loop-center',
			'file'  => '/css/parts/woo-categories-loop-center-old',
		),
	),
	'categories-loop-replace-title'                             => array(
		array(
			'title' => esc_html__( 'Categories loop replace title', 'woodmart' ),
			'name'  => 'categories-loop-replace-title',
			'file'  => '/css/parts/woo-categories-loop-replace-title-old',
		),
	),
	'woo-gutenberg'                                             => array(
		array(
			'title' => esc_html__( 'WooCommerce gutenberg', 'woodmart' ),
			'name'  => 'woo-gutenberg',
			'file'  => '/css/parts/woo-gutenberg',
			'rtl'   => true,
		),
	),
	'woo-opt-title-limit'                                       => array(
		array(
			'title' => esc_html__( 'WooCommerce title limit', 'woodmart' ),
			'name'  => 'woo-opt-title-limit',
			'file'  => '/css/parts/woo-opt-title-limit',
		),
	),
	'woo-opt-quick-shop'                                        => array(
		array(
			'title' => esc_html__( 'WooCommerce quick shop', 'woodmart' ),
			'name'  => 'woo-opt-quick-shop',
			'file'  => '/css/parts/woo-opt-quick-shop',
			'rtl'   => true,
		),
	),
	'woo-opt-quick-view'                                        => array(
		array(
			'title' => esc_html__( 'WooCommerce quick view', 'woodmart' ),
			'name'  => 'woo-opt-quick-view',
			'file'  => '/css/parts/woo-opt-quick-view',
		),
	),
	'woo-opt-demo-store'                                        => array(
		array(
			'title' => esc_html__( 'WooCommerce opt demo store', 'woodmart' ),
			'name'  => 'woo-opt-demo-store',
			'file'  => '/css/parts/woo-opt-demo-store',
			'rtl'   => true,
		),
	),
	'woo-mod-add-btn-replace'                                   => array(
		array(
			'title' => esc_html__( 'WooCommerce add to cart button replace', 'woodmart' ),
			'name'  => 'woo-mod-add-btn-replace',
			'file'  => '/css/parts/woo-mod-add-btn-replace',
			'rtl'   => true,
		),
	),
	'woo-mod-product-labels'                                    => array(
		array(
			'title' => esc_html__( 'WooCommerce product labels', 'woodmart' ),
			'name'  => 'woo-mod-product-labels',
			'file'  => '/css/parts/woo-mod-product-labels',
			'rtl'   => true,
		),
	),
	'woo-mod-product-labels-rect'                               => array(
		array(
			'title' => esc_html__( 'WooCommerce product labels rect', 'woodmart' ),
			'name'  => 'woo-mod-product-labels-rect',
			'file'  => '/css/parts/woo-mod-product-labels-rect',
			'rtl'   => true,
		),
	),
	'woo-mod-product-labels-round'                              => array(
		array(
			'title' => esc_html__( 'WooCommerce product labels round', 'woodmart' ),
			'name'  => 'woo-mod-product-labels-round',
			'file'  => '/css/parts/woo-mod-product-labels-round',
			'rtl'   => true,
		),
	),
	'woo-mod-login-form'                                        => array(
		array(
			'title' => esc_html__( 'WooCommerce mod login form', 'woodmart' ),
			'name'  => 'woo-mod-login-form',
			'file'  => '/css/parts/woo-mod-login-form',
		),
	),
	'woo-page-login-register'                                   => array(
		array(
			'title' => esc_html__( 'WooCommerce page login register', 'woodmart' ),
			'name'  => 'woo-page-login-register',
			'file'  => '/css/parts/woo-page-login-register',
			'rtl'   => true,
		),
	),
	'woo-opt-social-login'                                      => array(
		array(
			'title' => esc_html__( 'WooCommerce opt social login', 'woodmart' ),
			'name'  => 'woo-opt-social-login',
			'file'  => '/css/parts/woo-opt-social-login',
			'rtl'   => true,
		),
	),
	'mod-star-rating'                                           => array(
		array(
			'title' => esc_html__( 'WooCommerce star rating mod', 'woodmart' ),
			'name'  => 'mod-star-rating',
			'file'  => '/css/parts/mod-star-rating',
			'rtl'   => true,
		),
	),
	'woo-opt-hide-larger-price'                                 => array(
		array(
			'title' => esc_html__( 'WooCommerce hide larger price', 'woodmart' ),
			'name'  => 'woo-opt-hide-larger-price',
			'file'  => '/css/parts/woo-opt-hide-larger-price',
			'rtl'   => true,
		),
	),
	'woo-single-prod-predefined'                                => array(
		array(
			'title' => esc_html__( 'WooCommerce single product predefined', 'woodmart' ),
			'name'  => 'woo-single-prod-predefined',
			'file'  => '/css/parts/woo-single-prod-predefined',
			'rtl'   => true,
		),
	),
	'woo-single-prod-and-quick-view-predefined'                 => array(
		array(
			'title' => esc_html__( 'WooCommerce single product predefined', 'woodmart' ),
			'name'  => 'woo-single-prod-and-quick-view-predefined',
			'file'  => '/css/parts/woo-single-prod-and-quick-view-predefined',
			'rtl'   => true,
		),
	),
	'woo-single-prod-el-tabs-predefined'                        => array(
		array(
			'title' => esc_html__( 'WooCommerce single product tabs predefined', 'woodmart' ),
			'name'  => 'woo-single-prod-el-tabs-predefined',
			'file'  => '/css/parts/woo-single-prod-el-tabs-predefined',
		),
	),
	'woo-single-prod-builder'                                   => array(
		array(
			'title' => esc_html__( 'WooCommerce single product builder', 'woodmart' ),
			'name'  => 'woo-single-prod-builder',
			'file'  => '/css/parts/woo-single-prod-builder',
		),
	),
	'woo-single-prod-el-add-to-cart-opt-design-justify-builder' => array(
		array(
			'title' => esc_html__( 'WooCommerce single product inline add to cart', 'woodmart' ),
			'name'  => 'woo-single-prod-el-add-to-cart-opt-design-justify-builder',
			'file'  => '/css/parts/woo-single-prod-el-add-to-cart-opt-design-justify-builder',
		),
	),
	'opt-disable-owl'                                           => array(
		array(
			'title' => esc_html__( 'WooCommerce disable owl', 'woodmart' ),
			'name'  => 'opt-disable-owl',
			'file'  => '/css/parts/opt-disable-owl',
			'rtl'   => true,
		),
	),
	'woo-el-breadcrumbs'                                  => array(
		array(
			'title' => esc_html__( 'WooCommerce breadcrumbs', 'woodmart' ),
			'name'  => 'woo-el-breadcrumbs',
			'file'  => '/css/parts/woo-el-breadcrumbs',
		),
	),

	// Base.
	'page-title'                                                => array(
		array(
			'title' => esc_html__( 'Page title', 'woodmart' ),
			'name'  => 'page-title',
			'file'  => '/css/parts/page-title',
		),
	),
	'blog-base'                                                 => array(
		array(
			'title' => esc_html__( 'Blog base', 'woodmart' ),
			'name'  => 'blog-base',
			'file'  => '/css/parts/blog-base',
			'rtl'   => true,
		),
	),
	'portfolio-base'                                            => array(
		array(
			'title' => esc_html__( 'Portfolio base', 'woodmart' ),
			'name'  => 'portfolio-base',
			'file'  => '/css/parts/portfolio-base',
			'rtl'   => true,
		),
	),
	'page-404'                                                  => array(
		array(
			'title' => esc_html__( 'Page 404', 'woodmart' ),
			'name'  => 'page-404',
			'file'  => '/css/parts/page-404',
		),
	),
	'wp-gutenberg'                                              => array(
		array(
			'title' => esc_html__( 'Gutenberg', 'woodmart' ),
			'name'  => 'wp-gutenberg',
			'file'  => '/css/parts/wp-gutenberg',
			'rtl'   => true,
		),
	),
	'page-search-results'                                       => array(
		array(
			'title' => esc_html__( 'Search page', 'woodmart' ),
			'name'  => 'page-search-results',
			'file'  => '/css/parts/page-search-results',
			'rtl'   => true,
		),
	),
	// Options.
	'collapsible-content'                                       => array(
		array(
			'title'    => esc_html__( 'Collapsible content', 'woodmart' ),
			'name'     => 'collapsible-content',
			'file'     => '/css/parts/elem-opt-collapsible-content',
			'wpb_file' => '/css/parts/wpb-opt-collapsible-content',
		),
	),
	'age-verify'                                                => array(
		array(
			'title' => esc_html__( 'Age verify option', 'woodmart' ),
			'name'  => 'age-verify',
			'file'  => '/css/parts/opt-age-verify',
		),
	),
	'bottom-toolbar'                                            => array(
		array(
			'title' => esc_html__( 'Button navbar option', 'woodmart' ),
			'name'  => 'bottom-toolbar',
			'file'  => '/css/parts/opt-bottom-toolbar',
			'rtl'   => true,
		),
		array(
			'title' => esc_html__( 'Module tools', 'woodmart' ),
			'name'  => 'mod-tools',
			'file'  => '/css/parts/mod-tools',
			'rtl'   => true,
		),
	),
	'cookies-popup'                                             => array(
		array(
			'title' => esc_html__( 'Cookies popup option', 'woodmart' ),
			'name'  => 'cookies-popup',
			'file'  => '/css/parts/opt-cookies',
		),
	),
	'header-banner'                                             => array(
		array(
			'title' => esc_html__( 'Header banner option', 'woodmart' ),
			'name'  => 'header-banner',
			'file'  => '/css/parts/opt-header-banner',
			'rtl'   => true,
		),
	),
	'lazy-loading'                                              => array(
		array(
			'title' => esc_html__( 'Lazy loading option', 'woodmart' ),
			'name'  => 'lazy-loading',
			'file'  => '/css/parts/opt-lazy-load',
		),
	),
	'off-canvas-sidebar'                                        => array(
		array(
			'title' => esc_html__( 'Off canvas sidebar option', 'woodmart' ),
			'name'  => 'off-canvas-sidebar',
			'file'  => '/css/parts/opt-off-canvas-sidebar',
			'rtl'   => true,
		),
	),
	'promo-popup'                                               => array(
		array(
			'title' => esc_html__( 'Promo popup option', 'woodmart' ),
			'name'  => 'promo-popup',
			'file'  => '/css/parts/opt-promo-popup',
		),
	),
	'scroll-top'                                                => array(
		array(
			'title' => esc_html__( 'Scroll to top option', 'woodmart' ),
			'name'  => 'scroll-top',
			'file'  => '/css/parts/opt-scrolltotop',
			'rtl'   => true,
		),
	),
	'sticky-social-buttons'                                     => array(
		array(
			'title' => esc_html__( 'Sticky social buttons option', 'woodmart' ),
			'name'  => 'sticky-social-buttons',
			'file'  => '/css/parts/opt-sticky-social',
			'rtl'   => true,
		),
	),
	'opt-form-underline'                                        => array(
		array(
			'title' => esc_html__( 'Form underline option', 'woodmart' ),
			'name'  => 'opt-form-underline',
			'file'  => '/css/parts/opt-form-underline',
		),
	),
	'project-text-hover'                                        => array(
		array(
			'title' => esc_html__( 'Portfolio style option text hover', 'woodmart' ),
			'name'  => 'project-text-hover',
			'file'  => '/css/parts/project-text-hover',
		),
	),
	'project-alt'                                               => array(
		array(
			'title' => esc_html__( 'Portfolio style option alternative', 'woodmart' ),
			'name'  => 'project-alt',
			'file'  => '/css/parts/project-alt',
		),
	),
	'project-under'                                             => array(
		array(
			'title' => esc_html__( 'Portfolio style option text under image', 'woodmart' ),
			'name'  => 'project-under',
			'file'  => '/css/parts/project-under',
		),
	),
	'project-parallax'                                          => array(
		array(
			'title' => esc_html__( 'Portfolio style option parallax', 'woodmart' ),
			'name'  => 'project-parallax',
			'file'  => '/css/parts/project-parallax',
		),
	),
	// Libraries.
	'justified'                                                 => array(
		array(
			'title' => esc_html__( 'Justified gallery library', 'woodmart' ),
			'name'  => 'justified',
			'file'  => '/css/parts/lib-justified-gallery',
			'rtl'   => true,
		),
	),
	'mfp-popup'                                                 => array(
		array(
			'title' => esc_html__( 'Magnific popup library', 'woodmart' ),
			'name'  => 'mfp-popup',
			'file'  => '/css/parts/lib-magnific-popup',
			'rtl'   => true,
		),
	),
	'owl-carousel'                                              => array(
		array(
			'title' => esc_html__( 'Owl carousel library', 'woodmart' ),
			'name'  => 'owl-carousel',
			'file'  => '/css/parts/lib-owl-carousel',
			'rtl'   => true,
		),
	),
	'photoswipe'                                                => array(
		array(
			'title' => esc_html__( 'Photoswipe library', 'woodmart' ),
			'name'  => 'photoswipe',
			'file'  => '/css/parts/lib-photoswipe',
			'rtl'   => true,
		),
	),
	// Integrations.
	'wpbakery-base'                                             => array(
		array(
			'title' => esc_html__( 'WPBakery integration', 'woodmart' ),
			'name'  => 'wpbakery-base',
			'file'  => '/css/parts/int-wpb-base',
			'rtl'   => true,
		),
	),
	'wpbakery-base-deprecated'                                  => array(
		array(
			'title' => esc_html__( 'WPBakery integration deprecated', 'woodmart' ),
			'name'  => 'wpbakery-base-deprecated',
			'file'  => '/css/parts/int-wpb-base-deprecated',
		),
	),
	'base-deprecated'                                           => array(
		array(
			'title' => esc_html__( 'Base deprecated', 'woodmart' ),
			'name'  => 'base-deprecated',
			'file'  => '/css/parts/base-deprecated',
			'rtl'   => true,
		),
	),
	'elementor-base'                                            => array(
		array(
			'title' => esc_html__( 'Elementor integration', 'woodmart' ),
			'name'  => 'elementor-base',
			'file'  => '/css/parts/int-elem-base',
			'rtl'   => true,
		),
	),
	'elementor-pro-base'                                        => array(
		array(
			'title' => esc_html__( 'Elementor Pro integration', 'woodmart' ),
			'name'  => 'elementor-pro-base',
			'file'  => '/css/parts/int-elementor-pro',
			'rtl'   => true,
		),
	),
	'advanced-nocaptcha'                                        => array(
		array(
			'title' => esc_html__( 'Advanced Nocaptcha integration', 'woodmart' ),
			'name'  => 'advanced-nocaptcha',
			'file'  => '/css/parts/int-advanced-nocaptcha',
		),
	),
	'bbpress'                                                   => array(
		array(
			'title' => esc_html__( 'BBPress integration', 'woodmart' ),
			'name'  => 'bbpress',
			'file'  => '/css/parts/int-bbpress',
		),
	),
	'wpcf7'                                                     => array(
		array(
			'title' => esc_html__( 'Contacts form 7 integration', 'woodmart' ),
			'name'  => 'wpcf7',
			'file'  => '/css/parts/int-wpcf7',
			'rtl'   => true,
		),
	),
	'woo-curr-switch'                                           => array(
		array(
			'title' => esc_html__( 'WC currency switcher integration', 'woodmart' ),
			'name'  => 'woo-curr-switch',
			'file'  => '/css/parts/int-woo-curr-switch',
		),
	),
	'woo-dokan-vend'                                            => array(
		array(
			'title' => esc_html__( 'Dokan integration', 'woodmart' ),
			'name'  => 'woo-dokan-vend',
			'file'  => '/css/parts/int-woo-dokan-vend',
			'rtl'   => true,
		),
	),
	'woo-germanized'                                            => array(
		array(
			'title' => esc_html__( 'Germanized integration', 'woodmart' ),
			'name'  => 'woo-germanized',
			'file'  => '/css/parts/int-woo-germanized',
		),
	),
	'mc4wp'                                                     => array(
		array(
			'title' => esc_html__( 'Mailchimp for wordpress integration', 'woodmart' ),
			'name'  => 'mc4wp',
			'file'  => '/css/parts/int-mc4wp',
		),
	),
	'mc4wp-deprecated'                                          => array(
		array(
			'title' => esc_html__( 'Mailchimp for wordpress integration (deprecated)', 'woodmart' ),
			'name'  => 'mc4wp-deprecated',
			'file'  => '/css/parts/int-mc4wp-deprecated',
		),
	),
	'woo-paypal-express'                                        => array(
		array(
			'title' => esc_html__( 'PayPal Express integration', 'woodmart' ),
			'name'  => 'woo-paypal-express',
			'file'  => '/css/parts/int-woo-paypal-express',
			'rtl'   => true,
		),
	),
	'revolution-slider'                                         => array(
		array(
			'title' => esc_html__( 'Slider Revolution integration', 'woodmart' ),
			'name'  => 'revolution-slider',
			'file'  => '/css/parts/int-rev-slider',
		),
	),
	'woo-stripe'                                                => array(
		array(
			'title' => esc_html__( 'Stripe integration', 'woodmart' ),
			'name'  => 'woo-stripe',
			'file'  => '/css/parts/int-woo-stripe',
			'rtl'   => true,
		),
	),
	'woo-wcfm-fm'                                               => array(
		array(
			'title' => esc_html__( 'WCFM – Frontend Manager integration', 'woodmart' ),
			'name'  => 'woo-wcfm-fm',
			'file'  => '/css/parts/int-woo-wcfm-vend',
		),
	),
	'woo-wc-marketplace'                                        => array(
		array(
			'title' => esc_html__( 'Multivendor Marketplace integration', 'woodmart' ),
			'name'  => 'woo-wc-marketplace',
			'file'  => '/css/parts/int-woo-marketplace-vend',
		),
	),
	'woo-wc-vendors'                                            => array(
		array(
			'title' => esc_html__( 'WC Vendors integration', 'woodmart' ),
			'name'  => 'woo-wc-vendors',
			'file'  => '/css/parts/int-woo-wc-vend',
		),
	),
	'wpml'                                                      => array(
		array(
			'title' => esc_html__( 'WPML integration', 'woodmart' ),
			'name'  => 'wpml',
			'file'  => '/css/parts/int-wpml',
			'rtl'   => true,
		),
	),
	'woo-yith-compare'                                          => array(
		array(
			'title' => esc_html__( 'YITH Compare integration', 'woodmart' ),
			'name'  => 'woo-yith-compare',
			'file'  => '/css/parts/int-woo-yith-compare',
		),
	),
	'woo-yith-vendor'                                           => array(
		array(
			'title' => esc_html__( 'YITH Vendor integration', 'woodmart' ),
			'name'  => 'woo-yith-vendor',
			'file'  => '/css/parts/int-woo-yith-vend',
		),
	),
	'woo-yith-req-quote'                                        => array(
		array(
			'title' => esc_html__( 'YITH Request Quote integration', 'woodmart' ),
			'name'  => 'woo-yith-req-quote',
			'file'  => '/css/parts/int-woo-yith-request-quote',
			'rtl'   => true,
		),
	),
	'woo-yith-wishlist'                                         => array(
		array(
			'title' => esc_html__( 'YITH Wishlist integration', 'woodmart' ),
			'name'  => 'woo-yith-wishlist',
			'file'  => '/css/parts/int-woo-yith-wishlist',
		),
	),
	// Elements options.
	'product-arrows'                                            => array(
		array(
			'title' => esc_html__( 'Product arrows', 'woodmart' ),
			'name'  => 'product-arrows',
			'file'  => '/css/parts/el-opt-product-arrows',
		),
	),
	'highlighted-product'                                       => array(
		array(
			'title' => esc_html__( 'Highlighted product', 'woodmart' ),
			'name'  => 'highlighted-product',
			'file'  => '/css/parts/el-opt-highlight-product',
			'rtl'   => true,
		),
	),
	'int-el-animations'                                         => array(
		array(
			'title'    => esc_html__( 'Element animations', 'woodmart' ),
			'name'     => 'int-el-animations',
			'file'     => '/css/parts/int-elem-el-animations',
			'wpb_file' => '/css/parts/int-wbp-el-animations',
		),
	),
	'mod-highlighted-text'                                      => array(
		array(
			'title' => esc_html__( 'Element highlighted text', 'woodmart' ),
			'name'  => 'mod-highlighted-text',
			'file'  => '/css/parts/mod-highlighted-text',
		),
	),
	'int-elem-opt-off-canvas-column'                            => array(
		array(
			'title' => esc_html__( 'Element option off canvas column (Elementor)', 'woodmart' ),
			'name'  => 'int-elem-opt-off-canvas-column',
			'file'  => '/css/parts/int-elem-opt-off-canvas-column',
		),
	),
	'int-wpb-opt-off-canvas-column'                             => array(
		array(
			'title' => esc_html__( 'Element option off canvas column (WPBakery)', 'woodmart' ),
			'name'  => 'int-wpb-opt-off-canvas-column',
			'file'  => '/css/parts/int-wpb-opt-off-canvas-column',
		),
	),
	'el-off-canvas-column-btn'                                  => array(
		array(
			'title' => esc_html__( 'Off canvas column btn', 'woodmart' ),
			'name'  => 'el-off-canvas-column-btn',
			'file'  => '/css/parts/el-off-canvas-column-btn',
			'rtl'   => true,
		),
	),
	'mod-sticky-sidebar-opener'                                 => array(
		array(
			'title' => esc_html__( 'Off canvas column btn mod sticky sidebar opener', 'woodmart' ),
			'name'  => 'mod-sticky-sidebar-opener',
			'file'  => '/css/parts/mod-sticky-sidebar-opener',
			'rtl'   => true,
		),
	),
	// Elements.
	'tabs'                                                      => array(
		array(
			'title' => esc_html__( 'Tabs element', 'woodmart' ),
			'name'  => 'tabs',
			'file'  => '/css/parts/el-tabs',
			'rtl'   => true,
		),
	),
	'accordion'                                                 => array(
		array(
			'title' => esc_html__( 'Accordion element', 'woodmart' ),
			'name'  => 'accordion',
			'file'  => '/css/parts/el-accordion',
			'rtl'   => true,
		),
	),
	'360degree'                                                 => array(
		array(
			'title' => esc_html__( '360 element', 'woodmart' ),
			'name'  => '360degree',
			'file'  => '/css/parts/el-360deg',
			'rtl'   => true,
		),
	),
	'banner'                                                    => array(
		array(
			'title'    => esc_html__( 'Banner element', 'woodmart' ),
			'name'     => 'banner',
			'file'     => '/css/parts/el-banner',
			'wpb_file' => '/css/parts/wpb-el-banner',
		),
	),
	'countdown'                                                 => array(
		array(
			'title' => esc_html__( 'Countdown element', 'woodmart' ),
			'name'  => 'countdown',
			'file'  => '/css/parts/el-countdown-timer',
			'rtl'   => true,
		),
	),
	'counter'                                                   => array(
		array(
			'title' => esc_html__( 'Counter element', 'woodmart' ),
			'name'  => 'counter',
			'file'  => '/css/parts/el-counter',
		),
	),
	'image-gallery'                                             => array(
		array(
			'title' => esc_html__( 'Image gallery element', 'woodmart' ),
			'name'  => 'image-gallery',
			'file'  => '/css/parts/el-gallery',
		),
	),
	'image-hotspot'                                             => array(
		array(
			'title' => esc_html__( 'Image hotspot element', 'woodmart' ),
			'name'  => 'image-hotspot',
			'file'  => '/css/parts/el-hotspot',
		),
	),
	'info-box'                                                  => array(
		array(
			'title' => esc_html__( 'Info box element', 'woodmart' ),
			'name'  => 'info-box',
			'file'  => '/css/parts/el-info-box',
			'rtl'   => true,
		),
	),
	'instagram'                                                 => array(
		array(
			'title' => esc_html__( 'Instagram element', 'woodmart' ),
			'name'  => 'instagram',
			'file'  => '/css/parts/el-instagram',
			'rtl'   => true,
		),
	),
	'list'                                                      => array(
		array(
			'title' => esc_html__( 'List element', 'woodmart' ),
			'name'  => 'list',
			'file'  => '/css/parts/el-list',
			'rtl'   => true,
		),
	),
	'map'                                                       => array(
		array(
			'title' => esc_html__( 'Google maps element', 'woodmart' ),
			'name'  => 'map',
			'file'  => '/css/parts/el-map',
			'rtl'   => true,
		),
	),
	'menu-price'                                                => array(
		array(
			'title' => esc_html__( 'Menu price element', 'woodmart' ),
			'name'  => 'menu-price',
			'file'  => '/css/parts/el-menu-price',
			'rtl'   => true,
		),
	),
	'pricing-table'                                             => array(
		array(
			'title' => esc_html__( 'Pricing table element', 'woodmart' ),
			'name'  => 'pricing-table',
			'file'  => '/css/parts/el-pricing-table',
			'rtl'   => true,
		),
	),
	'el-page-title-builder'                                     => array(
		array(
			'title' => esc_html__( 'Element page title builder', 'woodmart' ),
			'name'  => 'el-page-title-builder',
			'file'  => '/css/parts/el-page-title-builder',
		),
	),
	'responsive-text'                                           => array(
		array(
			'title' => esc_html__( 'Responsive text element', 'woodmart' ),
			'name'  => 'responsive-text',
			'file'  => '/css/parts/el-responsive-text',
			'rtl'   => true,
		),
	),
	'text-block'                                                => array(
		array(
			'title' => esc_html__( 'Text block element', 'woodmart' ),
			'name'  => 'text-block',
			'file'  => '/css/parts/el-text-block',
		),
	),
	'dividers'                                                  => array(
		array(
			'title' => esc_html__( 'Dividers element', 'woodmart' ),
			'name'  => 'dividers',
			'file'  => '/css/parts/el-row-divider',
		),
	),
	'section-title'                                             => array(
		array(
			'title' => esc_html__( 'Section title element', 'woodmart' ),
			'name'  => 'section-title',
			'file'  => '/css/parts/el-section-title',
			'rtl'   => true,
		),
	),
	'slider'                                                    => array(
		array(
			'title' => esc_html__( 'Slider element', 'woodmart' ),
			'name'  => 'slider',
			'file'  => '/css/parts/el-slider',
			'rtl'   => true,
		),
	),
	'social-icons'                                              => array(
		array(
			'title' => esc_html__( 'Social icons element', 'woodmart' ),
			'name'  => 'social-icons',
			'file'  => '/css/parts/el-social-icons',
		),
	),
	'team-member'                                               => array(
		array(
			'title' => esc_html__( 'Team member element', 'woodmart' ),
			'name'  => 'team-member',
			'file'  => '/css/parts/el-team-member',
		),
	),
	'testimonial'                                               => array(
		array(
			'title' => esc_html__( 'Testimonial element', 'woodmart' ),
			'name'  => 'testimonial',
			'file'  => '/css/parts/el-testimonial',
			'rtl'   => true,
		),
	),
	'testimonial-old'                                           => array(
		array(
			'title' => esc_html__( 'Testimonial old element', 'woodmart' ),
			'name'  => 'testimonial-old',
			'file'  => '/css/parts/el-testimonial-old',
			'rtl'   => true,
		),
	),
	'timeline'                                                  => array(
		array(
			'title' => esc_html__( 'Timeline element', 'woodmart' ),
			'name'  => 'timeline',
			'file'  => '/css/parts/el-timeline',
			'rtl'   => true,
		),
	),
	'twitter'                                                   => array(
		array(
			'title' => esc_html__( 'Twitter element', 'woodmart' ),
			'name'  => 'twitter',
			'file'  => '/css/parts/el-twitter',
			'rtl'   => true,
		),
	),
	'el-product-filters'                                        => array(
		array(
			'title' => esc_html__( 'Product filters element', 'woodmart' ),
			'name'  => 'el-product-filters',
			'file'  => '/css/parts/el-product-filters',
			'rtl'   => true,
		),
	),
	'widget-collapse'                                           => array(
		array(
			'title' => esc_html__( 'Widget collapse', 'woodmart' ),
			'name'  => 'widget-collapse',
			'file'  => '/css/parts/opt-widget-collapse',
			'rtl'   => true,
		),
	),
	'filter-search'                                            => array(
		array(
			'title' => esc_html__( 'Filters search', 'woodmart' ),
			'name'  => 'filter-search',
			'file'  => '/css/parts/mod-filter-search',
			'rtl'   => true,
		),
	),
	'popular-requests'                                         => array(
		array(
			'title' => esc_html__( 'Search popular requests', 'woodmart' ),
			'name'  => 'popular-requests',
			'file'  => '/css/parts/opt-popular-requests',
		),
	),
	'dropdown-aside'                                           => array(
		array(
			'title' => esc_html__( 'Dropdown aside', 'woodmart' ),
			'name'  => 'dropdown-aside',
			'file'  => '/css/parts/mod-dropdown-aside',
			'rtl'   => true,
		),
	),
);
